/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.embeddiumplus.mixins.impl.dynlights;

import me.srrapero720.embeddiumplus.foundation.dynlights.DynLightsPlus;
import me.srrapero720.embeddiumplus.foundation.dynlights.accessors.DynamicLightSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderer.class})
public class EntityRendererMixin<T extends Entity> {
    @Inject(method={"getBlockLightLevel"}, at={@At(value="RETURN")}, cancellable=true)
    private void onGetBlockLight(T entity, BlockPos pos, CallbackInfoReturnable<Integer> cir) {
        if (!DynLightsPlus.isEnabled()) {
            return;
        }
        int vanilla = cir.getReturnValueI();
        int entityLuminance = ((DynamicLightSource)entity).tdv$getLuminance();
        if (entityLuminance >= 15) {
            cir.setReturnValue((Object)entityLuminance);
        }
        int posLuminance = (int)DynLightsPlus.get().getDynamicLightLevel(pos);
        cir.setReturnValue((Object)Math.max(Math.max(vanilla, entityLuminance), posLuminance));
    }
}

