/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.embeddiumplus.foundation.frames;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import me.srrapero720.embeddiumplus.EmbyConfig;
import me.srrapero720.embeddiumplus.EmbyTools;
import me.srrapero720.embeddiumplus.foundation.frames.FPSDisplay;
import me.srrapero720.embeddiumplus.foundation.frames.accessors.IUsageGPU;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FrameTimer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="embeddiumplus", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class DebugOverlayEvent {
    private static final FPSDisplay DISPLAY = new FPSDisplay();
    private static final Component MSG_FPS = Component.m_237115_((String)"embeddium.plus.options.displayfps.fps");
    private static final Component MSG_MIN = Component.m_237115_((String)"embeddium.plus.options.displayfps.min");
    private static final Component MSG_AVG = Component.m_237115_((String)"embeddium.plus.options.displayfps.avg");
    private static final Component MSG_GPU = Component.m_237115_((String)"embeddium.plus.options.displayfps.gpu");
    private static final Component MSG_MEM = Component.m_237115_((String)"embeddium.plus.options.displayfps.mem");
    private static final AverageQueue AVERAGE = new AverageQueue();
    private static int fps = -1;
    private static int minFPS = -1;
    private static int lastAvgFps = -1;
    private static int avgFPS = -1;
    private static int gpuPercent = -1;
    private static int memUsage = -1;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderOverlayItem(RenderGuiOverlayEvent.Pre event) {
        if (!event.getOverlay().id().m_135815_().equals("debug_text")) {
            return;
        }
        if (Minecraft.m_91087_().f_91066_.f_92065_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGuiEvent.Pre event) {
        Minecraft minecraft = Minecraft.m_91087_();
        DebugOverlayEvent.renderFPSChar(minecraft, event.getPoseStack(), minecraft.f_91062_, event.getWindow().m_85449_(), event.getWindow().m_85445_());
    }

    private static void renderFPSChar(Minecraft mc, PoseStack pose, Font font, double scale, int scaledWidth) {
        if (mc.f_91066_.f_92063_ || mc.f_91066_.f_92065_) {
            return;
        }
        EmbyConfig.FPSDisplayMode mode = (EmbyConfig.FPSDisplayMode)((Object)EmbyConfig.fpsDisplayMode.get());
        EmbyConfig.FPSDisplaySystemMode systemMode = (EmbyConfig.FPSDisplaySystemMode)((Object)EmbyConfig.fpsDisplaySystemMode.get());
        if (mode.off() && systemMode.off()) {
            return;
        }
        DISPLAY.release();
        switch (mode) {
            case SIMPLE: {
                DISPLAY.append(DebugOverlayEvent.calculateFPS$getColor(mc)).add(DebugOverlayEvent.fix(fps)).add(" ").add(MSG_FPS.getString()).add(ChatFormatting.RESET);
                break;
            }
            case ADVANCED: {
                DISPLAY.append(DebugOverlayEvent.calculateFPS$getColor(mc)).add(DebugOverlayEvent.fix(fps)).add(ChatFormatting.RESET);
                DISPLAY.append(DebugOverlayEvent.calculateMinFPS$getColor(mc)).add(MSG_MIN).add(" ").add(DebugOverlayEvent.fix(minFPS)).add(ChatFormatting.RESET);
                DISPLAY.append(DebugOverlayEvent.calculateAvgFPS$getColor(mc)).add(MSG_AVG).add(" ").add(DebugOverlayEvent.fix(avgFPS)).add(ChatFormatting.RESET);
            }
        }
        if (!DISPLAY.isEmpty()) {
            DISPLAY.split();
        }
        switch (systemMode) {
            case GPU: {
                DISPLAY.append(DebugOverlayEvent.calculateGPUPercent$getColor(mc)).add(MSG_GPU).add(" ").add(DebugOverlayEvent.fix(gpuPercent)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case RAM: {
                DISPLAY.append(DebugOverlayEvent.calculateMemPercent$getColor()).add(MSG_MEM).add(" ").add(DebugOverlayEvent.fix(memUsage)).add("%").add(ChatFormatting.RESET);
                break;
            }
            case ON: {
                DISPLAY.append(DebugOverlayEvent.calculateGPUPercent$getColor(mc)).add(MSG_GPU).add(" ").add(DebugOverlayEvent.fix(gpuPercent)).add("%").add(ChatFormatting.RESET);
                DISPLAY.append(DebugOverlayEvent.calculateMemPercent$getColor()).add(MSG_MEM).add(" ").add(DebugOverlayEvent.fix(memUsage)).add("%").add(ChatFormatting.RESET);
            }
        }
        if (DISPLAY.isEmpty()) {
            DISPLAY.add("FATAL ERROR");
        }
        float margin = scale > 0.0 ? (float)EmbyConfig.fpsDisplayMarginCache / (float)scale : (float)EmbyConfig.fpsDisplayMarginCache;
        String displayString = DISPLAY.toString();
        float maxPosX = scaledWidth - font.m_92895_(displayString);
        float posX = switch ((EmbyConfig.FPSDisplayGravity)((Object)EmbyConfig.fpsDisplayGravity.get())) {
            default -> throw new IncompatibleClassChangeError();
            case EmbyConfig.FPSDisplayGravity.LEFT -> margin;
            case EmbyConfig.FPSDisplayGravity.CENTER -> maxPosX / 2.0f;
            case EmbyConfig.FPSDisplayGravity.RIGHT -> maxPosX - margin;
        };
        float posY = margin;
        pose.m_85836_();
        if (EmbyConfig.fpsDisplayShadowCache) {
            int n = (int)posX - 2;
            int n2 = (int)posY - 2;
            int n3 = (int)posX + font.m_92895_(displayString) + 2;
            Objects.requireNonNull(font);
            GuiComponent.m_93172_((PoseStack)pose, (int)n, (int)n2, (int)n3, (int)((int)(posY + 9.0f) + 1), (int)-1873784752);
        }
        GuiComponent.m_93236_((PoseStack)pose, (Font)font, (String)displayString, (int)((int)posX), (int)((int)posY), (int)EmbyTools.getColorARGB(200, 255, 255, 255));
        DISPLAY.release();
        pose.m_85849_();
    }

    private static ChatFormatting calculateFPS$getColor(Minecraft mc) {
        fps = Minecraft.f_91021_;
        return EmbyTools.colorByLow(fps);
    }

    private static ChatFormatting calculateMinFPS$getColor(Minecraft mc) {
        FrameTimer timer = mc.m_91293_();
        int start = timer.m_13754_();
        int end = timer.m_13761_();
        if (end == start) {
            return EmbyTools.colorByLow(minFPS);
        }
        int fps = Minecraft.f_91021_;
        if (fps <= 0) {
            fps = 1;
        }
        long[] frames = timer.m_13764_();
        long maxNS = (long)(1.0 / (double)fps * 1.0E9);
        long totalNS = 0L;
        int index = Math.floorMod(end - 1, frames.length);
        while (index != start && (double)totalNS < 1.0E9) {
            long timeNs = frames[index];
            if (timeNs > maxNS) {
                maxNS = timeNs;
            }
            totalNS += timeNs;
            index = Math.floorMod(index - 1, frames.length);
        }
        minFPS = (int)(1.0 / ((double)maxNS / 1.0E9));
        return EmbyTools.colorByLow(minFPS);
    }

    private static ChatFormatting calculateAvgFPS$getColor(Minecraft mc) {
        if (Minecraft.f_91021_ != lastAvgFps) {
            lastAvgFps = Minecraft.f_91021_;
            AVERAGE.push(lastAvgFps);
            avgFPS = AVERAGE.calculate();
        }
        return EmbyTools.colorByLow(avgFPS);
    }

    private static ChatFormatting calculateGPUPercent$getColor(Minecraft mc) {
        int value = (int)((IUsageGPU)mc).embPlus$getSyncGpu();
        gpuPercent = value > 0 ? Math.min(value, 100) : -1;
        return EmbyTools.colorByPercent(gpuPercent);
    }

    private static ChatFormatting calculateMemPercent$getColor() {
        memUsage = (int)(EmbyTools.ramUsed() * 100L / Runtime.getRuntime().maxMemory());
        return EmbyTools.colorByPercent(memUsage);
    }

    private static String fix(int value) {
        return value == -1 ? "--" : "" + value;
    }

    public static class AverageQueue {
        private final int[] QUEUE = new int[14];
        private int used = 0;

        void push(int value) {
            if (this.used == this.QUEUE.length) {
                this.used = 0;
            }
            this.QUEUE[this.used] = value;
            ++this.used;
        }

        int calculate() {
            int times = 0;
            for (int i = 0; i < this.used; ++i) {
                times += this.QUEUE[i];
            }
            return times / this.used;
        }
    }
}

