/*
 * Decompiled with CFR 0.152.
 */
package me.srrapero720.embeddiumplus.foundation.dynlights;

import java.util.function.Function;
import me.srrapero720.embeddiumplus.EmbyConfig;
import me.srrapero720.embeddiumplus.foundation.dynlights.DynLightsPlus;
import me.srrapero720.embeddiumplus.foundation.dynlights.accessors.DynamicLightHolder;
import me.srrapero720.embeddiumplus.foundation.dynlights.events.DynLightsSetupEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="embeddiumplus", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public final class DynLightsHandlers {
    @SubscribeEvent
    public static void registerDefaultHandlers(DynLightsSetupEvent event) {
        DynLightsHandlers.registerDynamicLightHandler(EntityType.f_20551_, Entry.makeHandler(blaze -> 10, blaze -> true));
        DynLightsHandlers.registerDynamicLightHandler(EntityType.f_20558_, Entry.makeCreeperEntityHandler(null));
        DynLightsHandlers.registerDynamicLightHandler(EntityType.f_20566_, (T entity) -> {
            int luminance = 0;
            if (entity.m_32530_() != null) {
                luminance = entity.m_32530_().m_60791_();
            }
            return luminance;
        });
        DynLightsHandlers.registerDynamicLightHandler(EntityType.f_20461_, (T entity) -> DynLightsPlus.getLuminanceFromItemStack(entity.m_32055_(), entity.m_5842_()));
        DynLightsHandlers.registerDynamicLightHandler(EntityType.f_20462_, (T entity) -> {
            Level world = entity.m_20193_();
            return DynLightsPlus.getLuminanceFromItemStack(entity.m_31822_(), !world.m_6425_(entity.m_20183_()).m_76178_());
        });
        DynLightsHandlers.registerDynamicLightHandler(EntityType.f_147033_, (T entity) -> {
            Level world = entity.m_20193_();
            return Math.max(14, DynLightsPlus.getLuminanceFromItemStack(entity.m_31822_(), !world.m_6425_(entity.m_20183_()).m_76178_()));
        });
        DynLightsHandlers.registerDynamicLightHandler(EntityType.f_20468_, (T entity) -> (double)entity.f_33584_ > 0.6 ? 11 : 8);
        DynLightsHandlers.registerDynamicLightHandler(EntityType.f_20478_, (T entity) -> 8);
        DynLightsHandlers.registerDynamicLightHandler(EntityType.f_147034_, (T entity) -> (int)Mth.m_144920_((float)0.0f, (float)12.0f, (float)(1.0f - (float)entity.m_147128_() / 10.0f)));
    }

    public static <T extends Entity> void registerDynamicLightHandler(EntityType<T> type, Entry<T> handler) {
        DynLightsHandlers.register(DynamicLightHolder.cast(type), handler);
    }

    public static <T extends BlockEntity> void registerDynamicLightHandler(BlockEntityType<T> type, Entry<T> handler) {
        DynLightsHandlers.register(DynamicLightHolder.cast(type), handler);
    }

    private static <T> void register(DynamicLightHolder<T> holder, Entry<T> handler) {
        Entry registeredHandler = holder.lambdynlights$getDynamicLightHandler();
        if (registeredHandler != null) {
            holder.lambdynlights$setDynamicLightHandler(entity -> Math.max(registeredHandler.getLuminance(entity), handler.getLuminance(entity)));
        } else {
            holder.lambdynlights$setDynamicLightHandler(handler);
        }
    }

    @Nullable
    public static <T extends Entity> Entry<T> getDynamicLightHandler(EntityType<T> type) {
        return DynamicLightHolder.cast(type).lambdynlights$getDynamicLightHandler();
    }

    @Nullable
    public static <T extends BlockEntity> Entry<T> getDynamicLightHandler(BlockEntityType<T> type) {
        return DynamicLightHolder.cast(type).lambdynlights$getDynamicLightHandler();
    }

    public static <T extends Entity> boolean canLightUp(T entity) {
        return EmbyConfig.dynLightsOnEntitiesCache;
    }

    public static <T extends BlockEntity> boolean canLightUp(T entity) {
        return EmbyConfig.dynLightsOnTileEntitiesCache;
    }

    public static <T extends Entity> int getLuminanceFrom(T entity) {
        if (!EmbyConfig.dynLightsOnEntitiesCache) {
            return 0;
        }
        Entry<T> handler = DynLightsHandlers.getDynamicLightHandler(entity.m_6095_());
        if (handler == null) {
            return 0;
        }
        if (!DynLightsHandlers.canLightUp(entity)) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && !entity.m_20193_().m_6425_(new BlockPos(entity.m_146903_(), entity.m_146904_() + (int)entity.m_20192_(), entity.m_146907_())).m_76178_()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }

    public static <T extends BlockEntity> int getLuminanceFrom(T entity) {
        if (!EmbyConfig.dynLightsOnTileEntitiesCache) {
            return 0;
        }
        Entry<T> handler = DynLightsHandlers.getDynamicLightHandler(entity.m_58903_());
        if (handler == null) {
            return 0;
        }
        if (!DynLightsHandlers.canLightUp(entity)) {
            return 0;
        }
        if (handler.isWaterSensitive(entity) && entity.m_58904_() != null && !entity.m_58904_().m_6425_(entity.m_58899_()).m_76178_()) {
            return 0;
        }
        return handler.getLuminance(entity);
    }

    public static interface Entry<T> {
        public int getLuminance(T var1);

        default public boolean isWaterSensitive(T lightSource) {
            return false;
        }

        @NotNull
        public static <T extends LivingEntity> Entry<T> makeHandler(final Function<T, Integer> luminance, final Function<T, Boolean> waterSensitive) {
            return new Entry<T>(){

                @Override
                public int getLuminance(T lightSource) {
                    return (Integer)luminance.apply(lightSource);
                }

                @Override
                public boolean isWaterSensitive(T lightSource) {
                    return (Boolean)waterSensitive.apply(lightSource);
                }
            };
        }

        @NotNull
        public static <T extends LivingEntity> Entry<T> makeLivingEntityHandler(@NotNull Entry<T> handler) {
            return entity -> {
                int luminance = 0;
                for (ItemStack equipped : entity.m_20158_()) {
                    luminance = Math.max(luminance, DynLightsPlus.getLuminanceFromItemStack(equipped, entity.m_5842_()));
                }
                return Math.max(luminance, handler.getLuminance(entity));
            };
        }

        @NotNull
        public static <T extends Creeper> Entry<T> makeCreeperEntityHandler(final @Nullable Entry<T> handler) {
            return new Entry<T>(){

                @Override
                public int getLuminance(T entity) {
                    int luminance = 0;
                    if ((double)entity.m_32320_(0.0f) > 0.001) {
                        switch ((EmbyConfig.DynLightsSpeed)((Object)EmbyConfig.dynLightSpeed.get())) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case OFF: {
                                int n = 0;
                                break;
                            }
                            case NORMAL: 
                            case SLOW: 
                            case FAST: 
                            case SUPERFAST: 
                            case FASTESTS: {
                                int n = 12;
                                break;
                            }
                            case REALTIME: {
                                int n = luminance = (int)((double)entity.m_32320_(0.0f) * 12.0);
                            }
                        }
                    }
                    if (handler != null) {
                        luminance = Math.max(luminance, handler.getLuminance(entity));
                    }
                    return luminance;
                }

                @Override
                public boolean isWaterSensitive(T lightSource) {
                    return true;
                }
            };
        }
    }
}

