/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.forge;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.MissingMappingsEvent;
import samebutdifferent.ecologics.Ecologics;
import samebutdifferent.ecologics.block.FloweringAzaleaLogBlock;
import samebutdifferent.ecologics.block.PotBlock;
import samebutdifferent.ecologics.platform.forge.CommonPlatformHelperImpl;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.forge.ModConfigForge;
import samebutdifferent.ecologics.registry.forge.ModGlobalLootModifiers;

@Mod(value="ecologics")
@Mod.EventBusSubscriber(modid="ecologics")
public class EcologicsForge {
    public EcologicsForge() {
        Ecologics.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfigForge.COMMON_CONFIG);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CommonPlatformHelperImpl.BLOCKS.register(bus);
        CommonPlatformHelperImpl.ITEMS.register(bus);
        CommonPlatformHelperImpl.SOUND_EVENTS.register(bus);
        CommonPlatformHelperImpl.ENTITY_TYPES.register(bus);
        CommonPlatformHelperImpl.BLOCK_ENTITY_TYPES.register(bus);
        CommonPlatformHelperImpl.FEATURES.register(bus);
        CommonPlatformHelperImpl.TRUNK_PLACER_TYPES.register(bus);
        CommonPlatformHelperImpl.FOLIAGE_PLACER_TYPES.register(bus);
        CommonPlatformHelperImpl.MOB_EFFECTS.register(bus);
        CommonPlatformHelperImpl.POTIONS.register(bus);
        ModGlobalLootModifiers.GLM.register(bus);
        bus.addListener(this::registerEntityAttributes);
        bus.addListener(this::setup);
    }

    public void registerEntityAttributes(EntityAttributeCreationEvent event) {
        HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder> attributes = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier.Builder>();
        Ecologics.registerEntityAttributes(attributes);
        attributes.forEach((entity, builder) -> event.put(entity, builder.m_22265_()));
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> Ecologics.commonSetup());
    }

    @SubscribeEvent
    public static void onCropGrow(BlockEvent.CropGrowEvent.Post event) {
        BlockPos pos = event.getPos();
        LevelAccessor level = event.getLevel();
        BlockState state = event.getState();
        if (state.m_60713_(Blocks.f_50128_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50128_) && level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50128_) && level.m_46859_(pos.m_6630_(2)) && (double)level.m_213780_().m_188501_() <= (Double)ModConfigForge.PRICKLY_PEAR_GROWTH_CHANCE.get()) {
            level.m_7731_(pos.m_6630_(2), ModBlocks.PRICKLY_PEAR.get().m_49966_(), 2);
            level.m_5594_(null, pos, SoundEvents.f_11967_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        InteractionHand hand = event.getHand();
        if (state.m_60713_((Block)ModBlocks.POT.get()) && player.m_6047_()) {
            if (player.m_21205_().m_41720_() instanceof PickaxeItem && hand.equals((Object)InteractionHand.MAIN_HAND)) {
                level.m_46597_(pos, (BlockState)state.m_61122_((Property)PotBlock.CHISEL));
                level.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                player.m_6674_(InteractionHand.MAIN_HAND);
                player.m_21205_().m_41622_(1, (LivingEntity)player, plr -> plr.m_21190_(InteractionHand.MAIN_HAND));
            }
            if (player.m_21206_().m_41720_() instanceof PickaxeItem && !(player.m_21205_().m_41720_() instanceof PickaxeItem) && hand.equals((Object)InteractionHand.OFF_HAND)) {
                level.m_46597_(pos, (BlockState)state.m_61122_((Property)PotBlock.CHISEL));
                level.m_5594_(null, pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.4f + 0.8f);
                player.m_6674_(InteractionHand.OFF_HAND);
                player.m_21206_().m_41622_(1, (LivingEntity)player, plr -> plr.m_21190_(InteractionHand.OFF_HAND));
            }
        }
        if (!event.getLevel().f_46443_) {
            Direction direction;
            ItemStack stack = event.getItemStack();
            Direction direction2 = direction = event.getHitVec().m_82434_().m_122434_() == Direction.Axis.Y ? event.getHitVec().m_82434_().m_122424_() : event.getHitVec().m_82434_();
            if (stack.m_150930_(Items.f_42574_)) {
                if (state.m_60713_(Blocks.f_152542_)) {
                    FloweringAzaleaLogBlock.shearAzalea(level, player, pos, stack, hand, direction, Blocks.f_152541_.m_49966_());
                    player.m_21011_(hand, true);
                }
                if (state.m_60713_(Blocks.f_152471_)) {
                    FloweringAzaleaLogBlock.shearAzalea(level, player, pos, stack, hand, direction, (BlockState)((BlockState)Blocks.f_152470_.m_49966_().m_61124_((Property)LeavesBlock.f_54419_, (Comparable)((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)))).m_61124_((Property)LeavesBlock.f_54418_, (Comparable)((Integer)state.m_61143_((Property)LeavesBlock.f_54418_))));
                    player.m_21011_(hand, true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMissingBlockMappings(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping mapping : event.getAllMappings(ForgeRegistries.BLOCKS.getRegistryKey())) {
            ResourceLocation remapped;
            if (mapping.getKey().equals((Object)new ResourceLocation("ecologics", "coconut_husk"))) {
                remapped = new ResourceLocation("ecologics", "coconut_seedling");
                if (ForgeRegistries.BLOCKS.containsKey(remapped)) {
                    mapping.remap((Object)((Block)ForgeRegistries.BLOCKS.getValue(remapped)));
                } else {
                    mapping.warn();
                }
            }
            if (!mapping.getKey().equals((Object)new ResourceLocation("ecologics", "potted_coconut_husk"))) continue;
            remapped = new ResourceLocation("ecologics", "potted_coconut_seedling");
            if (ForgeRegistries.BLOCKS.containsKey(remapped)) {
                mapping.remap((Object)((Block)ForgeRegistries.BLOCKS.getValue(remapped)));
                continue;
            }
            mapping.warn();
        }
    }
}

