/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import samebutdifferent.ecologics.entity.CoconutCrab;
import samebutdifferent.ecologics.platform.ConfigPlatformHelper;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModSoundEvents;

public class HangingCoconutBlock
extends FallingBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    protected static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0), Block.m_49796_((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0)};

    public HangingCoconutBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60977_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockState aboveState = pLevel.m_8055_(pPos.m_7494_());
        return aboveState.m_60713_((Block)ModBlocks.COCONUT_LEAVES.get());
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == Direction.UP && !this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos) && (Integer)pState.m_61143_((Property)AGE) < 2) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean m_6724_(BlockState pState) {
        return true;
    }

    public void m_213898_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int age = (Integer)pState.m_61143_((Property)AGE);
        if (pRandom.m_188503_(3) == 0) {
            if (age < 2) {
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            } else if (pPos.m_123342_() >= pLevel.m_141937_() && HangingCoconutBlock.m_53241_((BlockState)pLevel.m_8055_(pPos.m_7495_()))) {
                FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)pLevel, (BlockPos)pPos, (BlockState)pLevel.m_8055_(pPos));
                this.m_6788_(fallingblockentity);
                pLevel.m_7967_((Entity)fallingblockentity);
                pLevel.m_7471_(pPos, false);
            }
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[(Integer)pState.m_61143_((Property)AGE)];
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.DESTROY;
    }

    public boolean m_7370_(BlockGetter pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return (Integer)pState.m_61143_((Property)AGE) < 2;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)pState.m_61143_((Property)AGE) + 1)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{AGE});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    protected void m_6788_(FallingBlockEntity pEntity) {
        pEntity.m_149656_(2.0f, 40);
    }

    public DamageSource m_142088_() {
        return new DamageSource("coconut");
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRand) {
        if (pRand.m_188503_(16) == 0 && (Integer)pState.m_61143_((Property)AGE) == 2) {
            double x = (double)pPos.m_123341_() + pRand.m_188500_();
            double y = (double)pPos.m_123342_() - 0.05;
            double z = (double)pPos.m_123343_() + pRand.m_188500_();
            pLevel.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, pState), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public int m_6248_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return 3873032;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        if (pLevel.m_46859_(pPos.m_7494_()) && pPos.m_123342_() >= pLevel.m_141937_() && HangingCoconutBlock.m_53241_((BlockState)pLevel.m_8055_(pPos.m_7495_()))) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.m_201971_((Level)pLevel, (BlockPos)pPos, (BlockState)pLevel.m_8055_(pPos));
            this.m_6788_(fallingblockentity);
            pLevel.m_7967_((Entity)fallingblockentity);
            pLevel.m_7471_(pPos, false);
        }
    }

    public void m_142525_(Level pLevel, BlockPos pPos, FallingBlockEntity pFallingBlock) {
        pLevel.m_5594_(null, pPos, ModSoundEvents.COCONUT_SMASH.get(), SoundSource.BLOCKS, 0.7f, 0.9f + pLevel.m_213780_().m_188501_() * 0.2f);
        if ((double)pLevel.f_46441_.m_188501_() <= ConfigPlatformHelper.coconutCrabSpawnChance()) {
            CoconutCrab coconutCrab = (CoconutCrab)ModEntityTypes.COCONUT_CRAB.get().m_20615_(pLevel);
            coconutCrab.m_6034_(pPos.m_123341_(), pPos.m_123342_(), pPos.m_123343_());
            pLevel.m_7967_((Entity)coconutCrab);
        } else {
            Block.m_49950_((BlockState)pFallingBlock.m_31980_(), (Level)pLevel, (BlockPos)pPos);
        }
    }
}

