/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.radiation.manager;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.deepresonance.modules.radiation.manager.QuadTree;
import mcjty.deepresonance.modules.radiation.util.RadiationConfiguration;
import mcjty.deepresonance.modules.radiation.util.RadiationShieldRegistry;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class DRRadiationManager
extends AbstractWorldData<DRRadiationManager> {
    private static final String RADIATION_MANAGER_NAME = "DRRadiationManager";
    private final Map<GlobalPos, RadiationSource> sources = Maps.newHashMap();

    public DRRadiationManager() {
    }

    public DRRadiationManager(CompoundTag tag) {
        ListTag lst = tag.m_128437_("radiation", 10);
        for (int i = 0; i < lst.size(); ++i) {
            CompoundTag tc = lst.m_128728_(i);
            ResourceKey type = LevelTools.getId((String)tc.m_128461_("dim"));
            GlobalPos coordinate = GlobalPos.m_122643_((ResourceKey)type, (BlockPos)new BlockPos(tc.m_128451_("sourceX"), tc.m_128451_("sourceY"), tc.m_128451_("sourceZ")));
            RadiationSource value = new RadiationSource();
            value.readFromNBT(tc);
            this.sources.put(coordinate, value);
        }
    }

    public void clear() {
        this.sources.clear();
    }

    public static float calculateRadiationStrength(double strength, double purity) {
        float p = (float)Math.log10(purity / 100.0) + 1.0f;
        if (p < 0.01f) {
            p = 0.01f;
        }
        double str = (Double)RadiationConfiguration.MIN_RADIATION_STRENGTH.get() + strength * (double)(1.0f - p) / 100.0 * ((Double)RadiationConfiguration.MAX_RADIATION_STRENGTH.get() - (Double)RadiationConfiguration.MIN_RADIATION_STRENGTH.get());
        return (float)str;
    }

    public static float calculateRadiationRadius(double strength, double efficiency, double purity) {
        double radius = (Double)RadiationConfiguration.MIN_RADIATION_RADIUS.get() + (strength + efficiency) / 200.0 * ((Double)RadiationConfiguration.MAX_RADIATION_RADIUS.get() - (Double)RadiationConfiguration.MIN_RADIATION_RADIUS.get());
        radius += radius * (100.0 - purity) * (double)0.002f;
        return (float)radius;
    }

    public void removeAllRadiation() {
        this.sources.clear();
    }

    public static DRRadiationManager getManager(Level world) {
        return (DRRadiationManager)DRRadiationManager.getData((Level)world, DRRadiationManager::new, DRRadiationManager::new, (String)RADIATION_MANAGER_NAME);
    }

    public RadiationSource getOrCreateRadiationSource(GlobalPos coordinate) {
        RadiationSource source = this.sources.get(coordinate);
        if (source == null) {
            source = new RadiationSource();
            this.sources.put(coordinate, source);
        }
        return source;
    }

    public RadiationSource getRadiationSource(GlobalPos coordinate) {
        return this.sources.get(coordinate);
    }

    public Map<GlobalPos, RadiationSource> getRadiationSources() {
        return this.sources;
    }

    public void deleteRadiationSource(GlobalPos coordinate) {
        this.sources.remove(coordinate);
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag tagCompound) {
        ListTag lst = new ListTag();
        for (Map.Entry<GlobalPos, RadiationSource> entry : this.sources.entrySet()) {
            CompoundTag tc = new CompoundTag();
            tc.m_128359_("dim", entry.getKey().m_122640_().m_135782_().toString());
            tc.m_128405_("sourceX", entry.getKey().m_122646_().m_123341_());
            tc.m_128405_("sourceY", entry.getKey().m_122646_().m_123342_());
            tc.m_128405_("sourceZ", entry.getKey().m_122646_().m_123343_());
            entry.getValue().writeToNBT(tc);
            lst.add((Object)tc);
        }
        tagCompound.m_128365_("radiation", (Tag)lst);
        return tagCompound;
    }

    public static class RadiationSource {
        private float radius;
        private float maxStrength;
        private float strength;
        private QuadTree radiationTree;

        public float getRadius() {
            return this.radius;
        }

        public void setRadius(float radius) {
            this.radius = radius;
        }

        public float getMaxStrength() {
            return this.maxStrength;
        }

        public void setMaxStrength(float maxStrength) {
            this.maxStrength = maxStrength;
        }

        public float getStrength() {
            return this.strength;
        }

        public void setStrength(float strength) {
            this.strength = strength;
        }

        public QuadTree getRadiationTree(Level world, int centerX, int centerY, int centerZ) {
            if (this.radiationTree == null) {
                this.radiationTree = new QuadTree((int)((float)centerX - this.radius - 1.0f), (int)((float)centerY - this.radius - 1.0f), (int)((float)centerZ - this.radius - 1.0f), (int)((float)centerX + this.radius + 1.0f), (int)((float)centerY + this.radius + 1.0f), (int)((float)centerZ + this.radius + 1.0f));
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                int x = (int)((float)centerX - this.radius);
                while ((float)x < (float)centerX + this.radius) {
                    int y = (int)((float)centerY - this.radius);
                    while ((float)y < (float)centerY + this.radius) {
                        int z = (int)((float)centerZ - this.radius);
                        while ((float)z < (float)centerZ + this.radius) {
                            pos.m_122178_(x, y, z);
                            BlockState block = world.m_8055_((BlockPos)pos);
                            float blocker = (float)RadiationShieldRegistry.getBlocker(block);
                            if (blocker < 0.99f) {
                                this.radiationTree.addBlocker((BlockPos)pos, blocker);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            return this.radiationTree;
        }

        public void update(float radius, float maxStrenght, int ticks) {
            this.maxStrength = maxStrenght;
            this.radius = radius;
            double toadd = (double)maxStrenght * (Double)RadiationConfiguration.STRENGTH_GROWTH_FACTOR.get() * (double)ticks;
            if ((double)this.strength + toadd > (double)maxStrenght && (toadd = (double)(maxStrenght - this.strength)) < 0.0) {
                toadd = 0.0;
            }
            this.strength = (float)((double)this.strength + toadd);
        }

        public void writeToNBT(CompoundTag tagCompound) {
            tagCompound.m_128350_("radius", this.radius);
            tagCompound.m_128350_("maxStrength", this.maxStrength);
            tagCompound.m_128350_("strength", this.strength);
        }

        public void readFromNBT(CompoundTag tagCompound) {
            this.radius = tagCompound.m_128457_("radius");
            this.maxStrength = tagCompound.m_128457_("maxStrength");
            this.strength = tagCompound.m_128457_("strength");
        }
    }
}

