/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.modules.generator.sound;

import com.google.common.collect.Maps;
import java.util.Map;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.sound.GeneratorSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;

public final class GeneratorSoundController {
    private static final Map<GlobalPos, GeneratorSound> sounds = Maps.newHashMap();

    public static void stopSound(Level worldObj, BlockPos pos) {
        GlobalPos g = GlobalPos.m_122643_((ResourceKey)worldObj.m_46472_(), (BlockPos)pos);
        if (sounds.containsKey(g)) {
            AbstractTickableSoundInstance movingSound = sounds.get(g);
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)movingSound);
            sounds.remove(g);
        }
    }

    private static void playSound(Level worldObj, BlockPos pos, SoundEvent soundType) {
        GeneratorSound sound = new GeneratorSound(soundType, worldObj, pos);
        GeneratorSoundController.stopSound(worldObj, pos);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
        GlobalPos g = GlobalPos.m_122643_((ResourceKey)worldObj.m_46472_(), (BlockPos)pos);
        sounds.put(g, sound);
    }

    public static void playStartup(Level worldObj, BlockPos pos) {
        GeneratorSoundController.playSound(worldObj, pos, (SoundEvent)GeneratorModule.STARTUP_SOUND.get());
    }

    public static void playLoop(Level worldObj, BlockPos pos) {
        GeneratorSoundController.playSound(worldObj, pos, (SoundEvent)GeneratorModule.LOOP_SOUND.get());
    }

    public static void playShutdown(Level worldObj, BlockPos pos) {
        GeneratorSoundController.playSound(worldObj, pos, (SoundEvent)GeneratorModule.SHUTDOWN_SOUND.get());
    }

    public static boolean isStartupPlaying(Level worldObj, BlockPos pos) {
        return GeneratorSoundController.isSoundTypePlayingAt((SoundEvent)GeneratorModule.STARTUP_SOUND.get(), worldObj, pos);
    }

    public static boolean isLoopPlaying(Level worldObj, BlockPos pos) {
        return GeneratorSoundController.isSoundTypePlayingAt((SoundEvent)GeneratorModule.LOOP_SOUND.get(), worldObj, pos);
    }

    public static boolean isShutdownPlaying(Level worldObj, BlockPos pos) {
        return GeneratorSoundController.isSoundTypePlayingAt((SoundEvent)GeneratorModule.SHUTDOWN_SOUND.get(), worldObj, pos);
    }

    private static boolean isSoundTypePlayingAt(SoundEvent event, Level world, BlockPos pos) {
        GeneratorSound s = GeneratorSoundController.getSoundAt(world, pos);
        return s != null && s.isSoundType(event);
    }

    private static GeneratorSound getSoundAt(Level world, BlockPos pos) {
        return sounds.get(GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos));
    }
}

