/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.compat;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.block.ResonatingCrystalBlock;
import mcjty.deepresonance.modules.generator.GeneratorModule;
import mcjty.deepresonance.modules.generator.data.GeneratorBlob;
import mcjty.deepresonance.modules.tank.TankModule;
import mcjty.deepresonance.modules.tank.data.TankBlob;
import mcjty.deepresonance.util.LiquidCrystalData;
import mcjty.lib.compat.theoneprobe.McJtyLibTOPDriver;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.varia.Tools;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class DeepResonanceTOPDriver
implements TOPDriver {
    public static final DeepResonanceTOPDriver DRIVER = new DeepResonanceTOPDriver();
    private final Map<ResourceLocation, TOPDriver> drivers = new HashMap<ResourceLocation, TOPDriver>();

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
        TOPDriver driver;
        ResourceLocation id = Tools.getId((BlockState)blockState);
        if (!this.drivers.containsKey(id)) {
            if (blockState.m_60734_() == GeneratorModule.GENERATOR_PART_BLOCK.get()) {
                this.drivers.put(id, new GeneratorPartDriver());
            } else if (blockState.m_60734_() == GeneratorModule.GENERATOR_CONTROLLER_BLOCK.get()) {
                this.drivers.put(id, new GeneratorControllerDriver());
            } else if (blockState.m_60734_() instanceof ResonatingCrystalBlock) {
                this.drivers.put(id, new CrystalDriver());
            } else if (blockState.m_60734_() == TankModule.TANK_BLOCK.get()) {
                this.drivers.put(id, new TankDriver());
            } else {
                this.drivers.put(id, new DefaultDriver());
            }
        }
        if ((driver = this.drivers.get(id)) != null) {
            driver.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }

    private static class GeneratorPartDriver
    implements TOPDriver {
        private GeneratorPartDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int id = te.getMultiblockId();
                probeInfo.text(CompoundText.createLabelInfo((String)"Id ", (Object)id));
                GeneratorBlob network = te.getBlob();
                probeInfo.text(CompoundText.createLabelInfo((String)"Collectors ", (Object)network.getCollectorBlocks()));
                probeInfo.text(CompoundText.createLabelInfo((String)"Generators ", (Object)network.getGeneratorBlocks()));
                probeInfo.text(CompoundText.createLabelInfo((String)"Energy ", (Object)network.getEnergy()));
            }, (String)"Bad tile entity!");
        }
    }

    private static class GeneratorControllerDriver
    implements TOPDriver {
        private GeneratorControllerDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), te -> {
                int level = te.getPowerLevel();
                probeInfo.text(CompoundText.createLabelInfo((String)"Power ", (Object)level));
            }, (String)"Bad tile entity!");
        }
    }

    private static class CrystalDriver
    implements TOPDriver {
        private CrystalDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), crystal -> {
                DecimalFormat fmt = new DecimalFormat("#.#");
                fmt.setRoundingMode(RoundingMode.DOWN);
                probeInfo.text(CompoundText.createLabelInfo((String)"Strength/Efficiency/Purity ", (Object)(fmt.format(crystal.getStrength()) + "% " + fmt.format(crystal.getEfficiency()) + "% " + fmt.format(crystal.getPurity()) + "%")));
                int rfPerTick = crystal.getRfPerTick();
                if (mode == ProbeMode.DEBUG) {
                    probeInfo.text(CompoundText.createLabelInfo((String)"RF/t ", (Object)(rfPerTick + " RF/t")));
                    probeInfo.text(CompoundText.createLabelInfo((String)"Power ", (Object)(fmt.format(crystal.getPower()) + "%")));
                    BlockState state = world.m_8055_(data.getPos());
                    if (state.m_60734_() instanceof ResonatingCrystalBlock) {
                        ResonatingCrystalBlock crystalBlock = (ResonatingCrystalBlock)state.m_60734_();
                        probeInfo.text(CompoundText.createLabelInfo((String)"Generated ", (Object)crystalBlock.isGenerated()));
                        probeInfo.text(CompoundText.createLabelInfo((String)"Empty ", (Object)crystalBlock.isEmpty()));
                    }
                } else {
                    probeInfo.horizontal().text(ChatFormatting.YELLOW + "Power: " + fmt.format(crystal.getPower()) + "% (" + rfPerTick + " RF/t)").progress((int)crystal.getPower(), 100, probeInfo.defaultProgressStyle().suffix("%").width(40).height(10).showText(false).filledColor(-65536).alternateFilledColor(-6750208));
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class TankDriver
    implements TOPDriver {
        private TankDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
            Tools.safeConsume((Object)world.m_7702_(data.getPos()), tank -> {
                TankBlob blob = tank.getBlob();
                if (blob != null) {
                    LiquidCrystalData d = blob.getData();
                    FluidStack stack = d.getFluidStack();
                    if (!stack.isEmpty()) {
                        probeInfo.tankSimple(blob.getCapacity(), stack);
                        if (stack.getFluid() == CoreModule.LIQUID_CRYSTAL.get()) {
                            DecimalFormat decimalFormat = new DecimalFormat("#.#");
                            decimalFormat.setRoundingMode(RoundingMode.DOWN);
                            probeInfo.text(CompoundText.createLabelInfo((String)"Quality ", (Object)(decimalFormat.format(d.getQuality() * 100.0) + "%")));
                            probeInfo.text(CompoundText.createLabelInfo((String)"Efficiency ", (Object)(decimalFormat.format(d.getEfficiency() * 100.0) + "%")));
                            probeInfo.text(CompoundText.createLabelInfo((String)"Purity ", (Object)(decimalFormat.format(d.getPurity() * 100.0) + "%")));
                            probeInfo.text(CompoundText.createLabelInfo((String)"Strength ", (Object)(decimalFormat.format(d.getStrength() * 100.0) + "%")));
                        }
                    }
                    if (mode == ProbeMode.DEBUG) {
                        probeInfo.text(CompoundText.createLabelInfo((String)"Id ", (Object)tank.getMultiblockId()));
                        probeInfo.text(CompoundText.createLabelInfo((String)"Client Height ", (Object)Float.valueOf(tank.getClientRenderHeight())));
                        probeInfo.text(CompoundText.createLabelInfo((String)"MinY ", (Object)blob.getMinY()));
                        probeInfo.text(CompoundText.createLabelInfo((String)"#Blocks ", (Object)blob.getTankBlocks()));
                    }
                }
            }, (String)"Bad tile entity!");
        }
    }

    private static class DefaultDriver
    implements TOPDriver {
        private DefaultDriver() {
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, Player player, Level world, BlockState blockState, IProbeHitData data) {
            McJtyLibTOPDriver.DRIVER.addStandardProbeInfo(mode, probeInfo, player, world, blockState, data);
        }
    }
}

