/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.client.model;

import com.kyanite.deeperdarker.content.entities.Shattered;
import com.kyanite.deeperdarker.content.entities.animations.ShatteredAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class ShatteredModel
extends HierarchicalModel<Shattered> {
    private final ModelPart root;
    private final ModelPart head;

    public ShatteredModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("root").m_171324_("body");
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.m_171576_();
        PartDefinition root = parts.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, -13.0f, -2.0f, 8.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(37, 6).m_171480_().m_171488_(0.0f, -11.0f, 2.0f, 0.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)0.0f));
        body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-12.0f, -11.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171514_(40, 0).m_171480_().m_171488_(4.0f, -11.0f, 0.0f, 8.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)0.0f));
        arms.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -2.0f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(43, 8).m_171488_(-4.0f, 11.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        arms.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 7.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 27).m_171488_(1.0f, 5.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition legs = root.m_171599_("legs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-13.0f, (float)0.0f));
        legs.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 33).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(4, 41).m_171488_(-1.0f, 4.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 47).m_171488_(-2.0f, 8.0f, -2.0f, 4.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        legs.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 33).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(Shattered entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(limbSwing, limbSwingAmount);
        this.m_233381_(entity.idleState, ShatteredAnimation.IDLE, ageInTicks);
        this.m_233381_(entity.attackState, ShatteredAnimation.ATTACK, ageInTicks);
    }

    private void animateWalk(float pLimbSwing, float pLimbSwingAmount) {
        long i = (long)(pLimbSwing * 50.0f * 2.0f);
        float f = Math.min(pLimbSwingAmount * 2.5f, 1.0f);
        KeyframeAnimations.m_232319_((HierarchicalModel)this, (AnimationDefinition)ShatteredAnimation.WALK, (long)i, (float)f, (Vector3f)new Vector3f());
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch) {
        netHeadYaw = Mth.m_14036_((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.m_14036_((float)headPitch, (float)-25.0f, (float)45.0f);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_171324_("root").m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

