/*
 * Decompiled with CFR 0.152.
 */
package me.mangorage.curiotiab.common.commands;

import com.haoict.tiab.config.TiabConfig;
import com.haoict.tiab.items.TimeInABottleItem;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import me.mangorage.curiotiab.common.core.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="curiotiab", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CurioTiabCommand {
    protected static boolean requires(CommandSourceStack stack) {
        return stack.m_6761_(2);
    }

    @SubscribeEvent
    public static void register(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"curiotiab").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"addTime").requires(CurioTiabCommand::requires)).then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer()).executes(stack -> CurioTiabCommand.processTimeCommand((CommandContext<CommandSourceStack>)stack, true))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"removeTime").requires(CurioTiabCommand::requires)).then(Commands.m_82129_((String)"seconds", (ArgumentType)IntegerArgumentType.integer()).executes(stack -> CurioTiabCommand.processTimeCommand((CommandContext<CommandSourceStack>)stack, false)))));
    }

    private static int processTimeCommand(CommandContext<CommandSourceStack> ctx, boolean isAdd) throws CommandSyntaxException {
        Item item;
        ItemStack tiabCurioItemStack;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = source.m_81375_();
        int timeToAdd = IntegerArgumentType.getInteger(ctx, (String)"seconds");
        if (timeToAdd < 0) {
            throw new NumberFormatException();
        }
        if (timeToAdd > (Integer)TiabConfig.COMMON.maxStoredTime.get() / 20) {
            timeToAdd = (Integer)TiabConfig.COMMON.maxStoredTime.get() / 20;
        }
        if ((tiabCurioItemStack = Util.getTiabCurioItemStack((Player)player)) != ItemStack.f_41583_ && (item = tiabCurioItemStack.m_41720_()) instanceof TimeInABottleItem) {
            TimeInABottleItem item2 = (TimeInABottleItem)item;
            int currentStoredEnergy = item2.getStoredEnergy(tiabCurioItemStack);
            if (!isAdd) {
                if (currentStoredEnergy / 20 < timeToAdd) {
                    timeToAdd = currentStoredEnergy / 20;
                }
                timeToAdd = -timeToAdd;
            }
            item2.setStoredEnergy(tiabCurioItemStack, currentStoredEnergy + timeToAdd * 20);
            Util.sendStatusMessage((Player)player, String.format("%s %d seconds", isAdd ? "Added" : "Removed ", timeToAdd));
        } else {
            Util.sendStatusMessage((Player)player, "No Time in a bottle item in curio slot");
        }
        return 1;
    }
}

