/*
 * Decompiled with CFR 0.152.
 */
package me.mangorage.curiotiab.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.mangorage.curiotiab.client.screens.overlays.CurioTiabHudOverlay;
import me.mangorage.curiotiab.common.core.Translatable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableInt;

public class ConfigurationScreen
extends Screen {
    private List<Component> components = new ArrayList<Component>();
    private int maxWidth = 0;
    private boolean hiddenMode = false;
    private int x;
    private int y = 5;

    public static void open(boolean tell) {
        if (tell) {
            Minecraft.m_91087_().m_6937_(() -> Minecraft.m_91087_().m_91152_((Screen)new ConfigurationScreen()));
        } else {
            Minecraft.m_91087_().m_91152_((Screen)new ConfigurationScreen());
        }
    }

    private ConfigurationScreen() {
        super((Component)Translatable.SCREEN_CONFIG.get(new Object[0]));
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        int cX = (int)(pMouseX < 0.0 ? 0.0 : pMouseX);
        int cY = (int)(pMouseY < 0.0 ? 0.0 : pMouseY);
        this.x = ConfigurationScreen.getClampedWidth(cX, this.f_96541_.f_91080_.f_96543_, this.maxWidth);
        int n = this.f_96541_.f_91080_.f_96544_;
        Objects.requireNonNull(this.f_96547_);
        this.y = ConfigurationScreen.getClampedHeight(cY, n, 9 * this.components.size());
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (ConfigurationScreen.m_96638_()) {
            if (pKeyCode == 82) {
                this.reset();
            }
            if (pKeyCode == 83) {
                this.save();
            }
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (!this.f_96541_.m_91396_()) {
            return;
        }
        int cX = ConfigurationScreen.getClampedWidth(this.x, this.f_96541_.f_91080_.f_96543_, this.maxWidth);
        int n = this.f_96541_.f_91080_.f_96544_;
        Objects.requireNonNull(this.f_96547_);
        int cY = ConfigurationScreen.getClampedHeight(this.y, n, 9 * this.components.size());
        this.m_7333_(pPoseStack);
        MutableInt finalID = new MutableInt(0);
        this.components.forEach(component -> {
            Objects.requireNonNull(this.f_96547_);
            ConfigurationScreen.m_93243_((PoseStack)pPoseStack, (Font)this.f_96547_, (Component)component, (int)cX, (int)(cY + 9 * finalID.getAndAdd(1)), (int)128);
        });
    }

    public void m_7379_() {
        CurioTiabHudOverlay.setHidden(this.hiddenMode);
        Translatable.SCREEN_CLOSED.sendSystemMessage((Player)this.f_96541_.f_91074_, ChatFormatting.GREEN);
        super.m_7379_();
    }

    public void updateComponents() {
        this.components.clear();
        this.components.add((Component)Translatable.SCREEN_DRAG.get(new Object[0]).m_130940_(ChatFormatting.GOLD));
        this.components.add((Component)Translatable.SCREEN_CLOSE.get(new Object[0]).m_130940_(ChatFormatting.GOLD));
        this.components.add((Component)Translatable.SCREEN_SAVE.get(new Object[0]).m_130940_(ChatFormatting.GOLD));
        this.components.add((Component)Translatable.SCREEN_RESET.get(new Object[0]).m_130940_(ChatFormatting.GOLD));
        this.maxWidth = ConfigurationScreen.getMaxStringsWidth(this.components, this.f_96547_);
    }

    protected void m_7856_() {
        this.hiddenMode = CurioTiabHudOverlay.isHidden();
        if (!this.hiddenMode) {
            CurioTiabHudOverlay.getInstance().toggleOverlay();
        }
        this.updateComponents();
        this.x = 5;
        this.y = 5;
    }

    private void save() {
        Translatable.MSG_SAVED.sendSystemMessage((Player)this.f_96541_.f_91074_, ChatFormatting.GREEN);
        CurioTiabHudOverlay.getInstance().setPosition(this.x, this.y);
    }

    private void reset() {
        Translatable.MSG_RESET.sendSystemMessage((Player)this.f_96541_.f_91074_, ChatFormatting.GREEN);
        CurioTiabHudOverlay.getInstance().setPosition(5, 5);
        this.x = 5;
        this.y = 5;
    }

    public static int getClampedWidth(int x, int screenwidth, int width) {
        return Math.min(x, screenwidth - width);
    }

    public static int getClampedHeight(int y, int screenheight, int height) {
        return ConfigurationScreen.getClampedWidth(y, screenheight, height);
    }

    public static int getMaxStringsWidth(List<Component> strings, Font font) {
        MutableInt value = new MutableInt(0);
        strings.forEach(s -> {
            int c = font.m_92852_((FormattedText)s);
            if (c > value.getValue()) {
                value.setValue(c);
            }
        });
        return value.getValue();
    }
}

