/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.common.capability;

import com.illusivesoulworks.culinaryconstruct.api.CulinaryConstructCapabilities;
import com.illusivesoulworks.culinaryconstruct.api.ICulinaryIngredient;
import com.illusivesoulworks.culinaryconstruct.common.capability.CulinaryIngredients;
import com.mojang.datafixers.util.Pair;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class CulinaryIngredientCapability {
    public static void setup() {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, CulinaryIngredientCapability::attachCapabilities);
    }

    public static ICapabilityProvider createCulinaryIngredient(ICulinaryIngredient ingredient) {
        return new Provider(ingredient);
    }

    private static void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        Item item = stack.m_41720_();
        for (Pair<Predicate<Item>, Function<ItemStack, ICulinaryIngredient>> entry : CulinaryIngredients.getDefaults()) {
            if (!((Predicate)entry.getFirst()).test(item)) continue;
            evt.addCapability(ICulinaryIngredient.INGREDIENT_ID, CulinaryIngredientCapability.createCulinaryIngredient((ICulinaryIngredient)((Function)entry.getSecond()).apply(stack)));
        }
    }

    public static class Provider
    implements ICapabilityProvider {
        final LazyOptional<ICulinaryIngredient> capability = LazyOptional.of(() -> ingredient);

        Provider(ICulinaryIngredient ingredient) {
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return CulinaryConstructCapabilities.CULINARY_INGREDIENT.orEmpty(cap, this.capability);
        }
    }
}

