/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.common.block;

import com.illusivesoulworks.culinaryconstruct.common.advancement.CraftFoodTrigger;
import com.illusivesoulworks.culinaryconstruct.common.block.CulinaryStationBlockEntity;
import com.illusivesoulworks.culinaryconstruct.common.registry.CulinaryConstructRegistry;
import com.illusivesoulworks.culinaryconstruct.common.util.CulinaryCalculator;
import com.illusivesoulworks.culinaryconstruct.platform.Services;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;

public class CulinaryStationMenu
extends AbstractContainerMenu {
    public static final int SLOT_COUNT = 7;
    private final Container container;
    private String outputItemName;

    public CulinaryStationMenu(int windowId, Inventory playerInventory, FriendlyByteBuf buf) {
        this(windowId, playerInventory, (Container)new SimpleContainer(7));
    }

    public CulinaryStationMenu(int windowId, Inventory playerInventory, @Nullable Container container) {
        super(CulinaryConstructRegistry.CULINARY_STATION_MENU.get(), windowId);
        this.container = container;
        this.addFoodSlots();
        this.addPlayerSlots(playerInventory);
    }

    private void addFoodSlots() {
        this.m_38897_(new CulinarySlot(this.container, 0, 8, 44));
        for (int i = 1; i < 6; ++i) {
            this.m_38897_(new CulinarySlot(this.container, i, 44 + (i - 1) * 18, 44));
        }
        this.m_38897_(new CulinaryResultSlot(this.container, 6, 152, 44));
    }

    private void addPlayerSlots(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 79 + row * 18));
            }
        }
        for (int hotbar = 0; hotbar < 9; ++hotbar) {
            this.m_38897_(new Slot((Container)playerInventory, hotbar, 8 + hotbar * 18, 137));
        }
    }

    public boolean m_6875_(@Nonnull Player playerIn) {
        return this.container.m_6542_(playerIn);
    }

    public void updateOutput() {
        ItemStack baseStack = this.container.m_8020_(0);
        if (baseStack.m_41619_()) {
            this.resetOutput();
            return;
        }
        NonNullList ingredientsList = NonNullList.m_122779_();
        for (int i = 1; i < this.container.m_6643_() - 1; ++i) {
            ItemStack stack = this.container.m_8020_(i);
            if (stack.m_41619_()) continue;
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(1);
            ingredientsList.add((Object)copy);
        }
        if (ingredientsList.isEmpty()) {
            this.resetOutput();
            return;
        }
        ItemStack baseCopy = baseStack.m_41777_();
        baseCopy.m_41764_(1);
        CulinaryCalculator calculator = new CulinaryCalculator(baseCopy, (NonNullList<ItemStack>)ingredientsList);
        ItemStack result = calculator.getResult();
        if (result.m_41619_()) {
            this.resetOutput();
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.outputItemName)) {
            result.m_41787_();
        } else if (!this.outputItemName.equals(result.m_41786_().getString())) {
            result.m_41714_((Component)Component.m_237113_((String)this.outputItemName));
        }
        this.setOutput(result);
    }

    private void setOutput(ItemStack stack) {
        this.container.m_6836_(6, stack);
        this.m_38946_();
    }

    private void resetOutput() {
        ItemStack stack = this.container.m_8020_(6);
        if (!stack.m_41619_()) {
            this.setOutput(ItemStack.f_41583_);
        }
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 6) {
                if (!this.m_38903_(itemstack1, 7, 43, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (index >= 7 && index < 43 ? !this.m_38903_(itemstack1, 0, 1, false) && !this.m_38903_(itemstack1, 1, 6, false) : !this.m_38903_(itemstack1, 7, 43, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void updateItemName(String newName) {
        this.outputItemName = newName;
        this.updateOutput();
    }

    public class CulinarySlot
    extends Slot {
        public CulinarySlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public void m_6654_() {
            CulinaryStationMenu.this.updateOutput();
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return this.f_40218_.m_7013_(this.f_40219_, stack);
        }
    }

    private class CulinaryResultSlot
    extends CulinarySlot {
        public CulinaryResultSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public void m_142406_(@Nonnull Player player, @Nonnull ItemStack stack) {
            Container container;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CraftFoodTrigger.INSTANCE.trigger(serverPlayer);
            }
            if ((container = CulinaryStationMenu.this.container) instanceof CulinaryStationBlockEntity) {
                CulinaryStationBlockEntity blockEntity = (CulinaryStationBlockEntity)container;
                for (int i = 0; i < blockEntity.m_6643_() - 1; ++i) {
                    ItemStack itemStack = blockEntity.m_8020_(i);
                    if (itemStack.m_41619_()) continue;
                    boolean isPotion = itemStack.m_41720_() instanceof PotionItem;
                    boolean isSoup = itemStack.m_41720_() instanceof BowlFoodItem;
                    ItemStack container2 = Services.PLATFORM.getContainerItem(itemStack);
                    itemStack.m_41774_(1);
                    if (container2.m_41619_()) {
                        if (isPotion) {
                            container2 = new ItemStack((ItemLike)Items.f_42590_);
                        } else if (isSoup) {
                            container2 = new ItemStack((ItemLike)Items.f_42399_);
                        }
                    }
                    if (container2.m_41619_()) continue;
                    Services.PLATFORM.giveItemToPlayer(container2, player);
                }
            }
            CulinaryStationMenu.this.updateOutput();
        }
    }
}

