/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.culinaryconstruct.client.model.color;

import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;

public class ColorMixer {
    public static int getDominantColor(TextureAtlasSprite sprite) {
        int iconWidth = sprite.m_118405_();
        int iconHeight = sprite.m_118408_();
        int frameCount = sprite.m_118415_();
        if (iconWidth <= 0 || iconHeight <= 0 || frameCount <= 0) {
            return 0xFFFFFF;
        }
        TreeMap<Integer, Integer> counts = new TreeMap<Integer, Integer>();
        for (int f = 0; f < frameCount; ++f) {
            for (int v = 0; v < iconWidth; ++v) {
                for (int u = 0; u < iconHeight; ++u) {
                    int rgba = sprite.getPixelRGBA(f, v, u);
                    int alpha = rgba >> 24 & 0xFF;
                    if (alpha <= 0) continue;
                    counts.merge(rgba, 1, (color, count) -> count + 1);
                }
            }
        }
        int dominantColor = 0;
        int dominantSum = 0;
        for (Map.Entry entry : counts.entrySet()) {
            if ((Integer)entry.getValue() <= dominantSum) continue;
            dominantSum = (Integer)entry.getValue();
            dominantColor = (Integer)entry.getKey();
        }
        Color color2 = new Color(dominantColor, true);
        return new Color(color2.getBlue(), color2.getGreen(), color2.getRed()).brighter().getRGB();
    }

    public static int getMixedColor(List<Integer> colors) {
        if (colors.isEmpty()) {
            return 0;
        }
        int[] aint = new int[3];
        int i = 0;
        int j = 0;
        for (Integer color : colors) {
            float f = (float)(color >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(color & 0xFF) / 255.0f;
            i = (int)((float)i + Math.max(f, Math.max(f1, f2)) * 255.0f);
            aint[0] = (int)((float)aint[0] + f * 255.0f);
            aint[1] = (int)((float)aint[1] + f1 * 255.0f);
            aint[2] = (int)((float)aint[2] + f2 * 255.0f);
            ++j;
        }
        int j1 = aint[0] / j;
        int k1 = aint[1] / j;
        int l1 = aint[2] / j;
        float f3 = (float)i / (float)j;
        float f4 = Math.max(j1, Math.max(k1, l1));
        j1 = (int)((float)j1 * f3 / f4);
        k1 = (int)((float)k1 * f3 / f4);
        l1 = (int)((float)l1 * f3 / f4);
        int j2 = (j1 << 8) + k1;
        j2 = (j2 << 8) + l1;
        return j2;
    }
}

