/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.balm.mixin.ImageButtonAccessor;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfig;
import net.blay09.mods.craftingtweaks.config.CraftingTweaksConfigData;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import org.jetbrains.annotations.Nullable;

public class CraftingGuideButtonFixer {
    public static void fixMistakes(AbstractContainerScreen<?> screen) {
        Button button = CraftingGuideButtonFixer.findCraftButton(((ScreenAccessor)screen).balm_getChildren());
        if (button != null) {
            CraftingTweaksConfigData config = CraftingTweaksConfig.getActive();
            if (config.client.hideVanillaCraftingGuide) {
                button.f_93624_ = false;
            } else if (!config.client.hideButtons && !(screen instanceof InventoryScreen)) {
                AbstractContainerScreenAccessor accessor = (AbstractContainerScreenAccessor)screen;
                button.f_93620_ = accessor.getLeftPos() + accessor.getImageWidth() - 25;
                button.f_93621_ = screen.getClass().getSimpleName().equals("GuiCraftingStation") ? accessor.getTopPos() + 37 : accessor.getTopPos() + 5;
                if (Balm.isModLoaded((String)"inventorytweaks")) {
                    button.f_93620_ -= 15;
                }
            }
        }
    }

    @Nullable
    private static Button findCraftButton(List<? extends GuiEventListener> buttonList) {
        return buttonList.stream().filter(p -> p instanceof ImageButton && ((ImageButtonAccessor)p).getResourceLocation() != null && ((ImageButtonAccessor)p).getResourceLocation().m_135815_().equals("textures/gui/recipe_button.png")).findFirst().orElse(null);
    }
}

