/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.layers;

import dev.compactmods.crafting.api.recipe.layers.IRecipeBlocks;
import dev.compactmods.crafting.recipes.blocks.RecipeBlocks;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public final class RecipeLayerUtil {
    private RecipeLayerUtil() {
    }

    public static IRecipeBlocks rotate(IRecipeBlocks original, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return new RecipeBlocks(original);
        }
        BlockPos[] originalPositions = (BlockPos[])original.getPositions().map(BlockPos::m_7949_).toArray(BlockPos[]::new);
        Map<BlockPos, BlockPos> rotatedPositions = BlockSpaceUtil.rotatePositionsInPlace(originalPositions, rotation);
        HashMap<BlockPos, BlockState> states = new HashMap<BlockPos, BlockState>();
        HashMap<BlockPos, String> componentKeys = new HashMap<BlockPos, String>();
        HashSet<BlockPos> unmatchedPositions = new HashSet<BlockPos>();
        for (BlockPos originalPos : originalPositions) {
            BlockPos rotatedPos = rotatedPositions.get(originalPos);
            states.put(rotatedPos, original.getStateAtPosition(originalPos));
            original.getComponentAtPosition(originalPos).ifPresent(m -> componentKeys.put(rotatedPos, (String)m));
        }
        if (!original.allIdentified()) {
            original.getUnmappedPositions().forEach(pos -> {
                BlockPos rotated = ((BlockPos)rotatedPositions.get(pos)).m_7949_();
                unmatchedPositions.add(rotated);
                original.getComponentAtPosition((BlockPos)pos).ifPresent(k -> componentKeys.put(rotated, (String)k));
            });
        }
        return new RecipeBlocks(original.getSourceBounds(), states, componentKeys, unmatchedPositions);
    }
}

