/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.recipes.layers;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.compactmods.crafting.api.components.IRecipeComponents;
import dev.compactmods.crafting.api.recipe.layers.IRecipeBlocks;
import dev.compactmods.crafting.api.recipe.layers.IRecipeLayer;
import dev.compactmods.crafting.api.recipe.layers.ISymmetricalLayer;
import dev.compactmods.crafting.api.recipe.layers.RecipeLayerType;
import dev.compactmods.crafting.api.recipe.layers.dim.IDynamicSizedRecipeLayer;
import dev.compactmods.crafting.core.CCLayerTypes;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FilledComponentRecipeLayer
implements IRecipeLayer,
IDynamicSizedRecipeLayer,
ISymmetricalLayer,
RecipeLayerType<FilledComponentRecipeLayer> {
    private final String componentKey;
    private AABB recipeDimensions;
    public static final Codec<FilledComponentRecipeLayer> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.STRING.fieldOf("component").forGetter(FilledComponentRecipeLayer::getComponent)).apply((Applicative)in, FilledComponentRecipeLayer::new));

    public FilledComponentRecipeLayer() {
        this.recipeDimensions = AABB.m_82333_((Vec3)Vec3.f_82478_);
        this.componentKey = "-";
    }

    public FilledComponentRecipeLayer(String component) {
        this.recipeDimensions = AABB.m_165882_((Vec3)Vec3.f_82478_, (double)0.0, (double)0.0, (double)0.0);
        this.componentKey = component;
    }

    public String getComponent() {
        return this.componentKey;
    }

    @Override
    public Set<String> getComponents() {
        return ImmutableSet.of((Object)this.componentKey);
    }

    @Override
    public Map<String, Integer> getComponentTotals() {
        return Collections.singletonMap(this.componentKey, this.getNumberFilledPositions());
    }

    @Override
    public Optional<String> getComponentForPosition(BlockPos pos) {
        if (this.recipeDimensions.m_82393_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) {
            return Optional.ofNullable(this.componentKey);
        }
        return Optional.empty();
    }

    @Override
    public Stream<BlockPos> getPositionsForComponent(String component) {
        return BlockSpaceUtil.getBlocksIn(this.recipeDimensions);
    }

    public int getNumberFilledPositions() {
        if (this.recipeDimensions == null) {
            return 0;
        }
        return (int)Math.ceil(this.recipeDimensions.m_82362_() * this.recipeDimensions.m_82385_());
    }

    @Override
    public boolean matches(IRecipeComponents components, IRecipeBlocks blocks) {
        if (!blocks.allIdentified()) {
            return false;
        }
        Map<String, Integer> totalsInWorld = blocks.getKnownComponentTotals();
        if (totalsInWorld.size() != 1) {
            return false;
        }
        if (!totalsInWorld.containsKey(this.componentKey)) {
            return false;
        }
        return this.getNumberFilledPositions() == totalsInWorld.get(this.componentKey).intValue();
    }

    @Override
    public RecipeLayerType<?> getType() {
        return (RecipeLayerType)CCLayerTypes.FILLED_LAYER_SERIALIZER.get();
    }

    @Override
    public void setRecipeDimensions(AABB dimensions) {
        this.recipeDimensions = dimensions;
    }

    @Override
    public Codec<FilledComponentRecipeLayer> getCodec() {
        return CODEC;
    }
}

