/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.proxies.data;

import dev.compactmods.crafting.api.field.IFieldListener;
import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.core.CCBlocks;
import dev.compactmods.crafting.core.CCCapabilities;
import dev.compactmods.crafting.proxies.data.BaseFieldProxyEntity;
import dev.compactmods.crafting.proxies.listener.MatchModeProxyFieldListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class MatchFieldProxyEntity
extends BaseFieldProxyEntity {
    protected LazyOptional<IFieldListener> listener = LazyOptional.empty();

    public MatchFieldProxyEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends BaseFieldProxyEntity>)((BlockEntityType)CCBlocks.MATCH_PROXY_ENTITY.get()), pos, state);
    }

    @Override
    protected void fieldChanged(LazyOptional<IMiniaturizationField> f) {
        super.fieldChanged(f);
        MatchModeProxyFieldListener listener = new MatchModeProxyFieldListener(this.f_58857_, this.f_58858_);
        this.listener = LazyOptional.of(() -> listener);
        f.ifPresent(f2 -> f2.registerListener(this.listener));
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CCCapabilities.FIELD_LISTENER) {
            return this.listener.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.listener.invalidate();
    }
}

