/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.network;

import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.api.recipe.IMiniaturizationRecipe;
import dev.compactmods.crafting.client.ClientPacketHandler;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class FieldRecipeChangedPacket {
    private final BlockPos fieldCenter;
    @Nullable
    private final ResourceLocation recipe;

    public FieldRecipeChangedPacket(IMiniaturizationField field) {
        this.fieldCenter = field.getCenter();
        this.recipe = field.getCurrentRecipe().map(IMiniaturizationRecipe::getRecipeIdentifier).orElse(null);
    }

    public FieldRecipeChangedPacket(FriendlyByteBuf buf) {
        this.fieldCenter = buf.m_130135_();
        this.recipe = buf.readBoolean() ? ResourceLocation.m_135820_((String)buf.m_130277_()) : null;
    }

    public static void encode(FieldRecipeChangedPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.fieldCenter);
        buf.writeBoolean(pkt.recipe != null);
        if (pkt.recipe != null) {
            buf.m_130070_(pkt.recipe.toString());
        }
    }

    public static boolean handle(FieldRecipeChangedPacket pkt, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientPacketHandler.handleRecipeChanged(pkt.fieldCenter, pkt.recipe));
        return true;
    }
}

