/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.field;

import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.EnumCraftingState;
import dev.compactmods.crafting.api.field.IActiveWorldFields;
import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import dev.compactmods.crafting.core.CCCapabilities;
import dev.compactmods.crafting.field.MissingFieldsException;
import dev.compactmods.crafting.projector.FieldProjectorBlock;
import dev.compactmods.crafting.server.ServerConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class FieldHelper {
    public static boolean checkBlockPlacement(Level level, BlockPos pos) throws MissingFieldsException {
        int maxDimensions = MiniaturizationFieldSize.maximum().getDimensions();
        AABB searchArea = new AABB(pos, pos).m_82400_((double)(maxDimensions + 3));
        BlockPos[] nearbyProjectors = (BlockPos[])BlockPos.m_121921_((AABB)searchArea).filter(possProjector -> level.m_8055_(possProjector).m_60734_() instanceof FieldProjectorBlock).filter(possProjector -> FieldProjectorBlock.isActive(level.m_8055_(possProjector))).map(BlockPos::m_7949_).toArray(BlockPos[]::new);
        if (((Boolean)ServerConfig.FIELD_BLOCK_CHANGES.get()).booleanValue()) {
            CompactCrafting.LOGGER.debug("Found {} nearby projectors near {}.", (Object)nearbyProjectors.length, (Object)pos);
        }
        Vec3 centerBlockChanged = Vec3.m_82512_((Vec3i)pos);
        if (nearbyProjectors.length > 0) {
            IActiveWorldFields fields = (IActiveWorldFields)level.getCapability(CCCapabilities.FIELDS).orElseThrow(() -> new MissingFieldsException("Could not fetch fields off level: " + level.m_46472_()));
            Optional<IMiniaturizationField> affectedField = fields.getFields().filter(field -> field.getBounds().m_82390_(centerBlockChanged)).findFirst();
            return affectedField.map(field -> {
                if (field.getCraftingState() == EnumCraftingState.CRAFTING) {
                    return false;
                }
                field.fieldContentsChanged();
                return true;
            }).orElse(true);
        }
        return true;
    }
}

