/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.events;

import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.field.IActiveWorldFields;
import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.core.CCCapabilities;
import dev.compactmods.crafting.network.ClientFieldUnwatchPacket;
import dev.compactmods.crafting.network.ClientFieldWatchPacket;
import dev.compactmods.crafting.network.NetworkHandler;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="compactcrafting")
public class WorldEventHandler {
    public static final Subject<ChunkEvent> CHUNK_CHANGES = PublishSubject.create();

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent evt) {
        CompactCrafting.LOGGER.trace("Server started; calling previously active fields to validate themselves.");
        for (ServerLevel level : evt.getServer().m_129785_()) {
            level.getCapability(CCCapabilities.FIELDS).resolve().ifPresent(fields -> {
                fields.setLevel((Level)level);
                fields.getFields().forEach(f -> {
                    f.setLevel((Level)level);
                    f.checkLoaded();
                });
            });
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START) {
            return;
        }
        evt.level.getCapability(CCCapabilities.FIELDS).ifPresent(IActiveWorldFields::tickFields);
    }

    @SubscribeEvent
    public static void onStartChunkTracking(ChunkWatchEvent.Watch event) {
        ServerPlayer player = event.getPlayer();
        ChunkPos pos = event.getPos();
        ServerLevel level = event.getLevel();
        level.getCapability(CCCapabilities.FIELDS).map(f -> f.getFields(pos)).ifPresent(activeFields -> activeFields.forEach(field -> {
            ClientFieldWatchPacket pkt = new ClientFieldWatchPacket((IMiniaturizationField)field);
            NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)pkt);
        }));
    }

    @SubscribeEvent
    public static void onStopChunkTracking(ChunkWatchEvent.UnWatch event) {
        ServerPlayer player = event.getPlayer();
        ChunkPos pos = event.getPos();
        ServerLevel level = event.getLevel();
        level.getCapability(CCCapabilities.FIELDS).map(f -> f.getFields(pos)).ifPresent(activeFields -> activeFields.forEach(field -> {
            ClientFieldUnwatchPacket pkt = new ClientFieldUnwatchPacket(field.getCenter());
            NetworkHandler.MAIN_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)pkt);
        }));
    }

    @SubscribeEvent
    public static void onChunkLoadStatusChanged(ChunkEvent cEvent) {
        if (cEvent instanceof ChunkEvent.Load || cEvent instanceof ChunkEvent.Unload) {
            CHUNK_CHANGES.onNext((Object)cEvent);
        }
    }
}

