/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.compat.theoneprobe.providers;

import dev.compactmods.crafting.api.EnumCraftingState;
import dev.compactmods.crafting.api.recipe.IMiniaturizationRecipe;
import dev.compactmods.crafting.core.CCCapabilities;
import dev.compactmods.crafting.projector.FieldProjectorBlock;
import dev.compactmods.crafting.projector.FieldProjectorEntity;
import java.util.Set;
import mcjty.theoneprobe.api.Color;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FieldProjectorProvider
implements IProbeInfoProvider {
    private static final ResourceLocation ID = new ResourceLocation("compactcrafting", "field_projector");

    public ResourceLocation getID() {
        return ID;
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, Player player, Level level, BlockState state, IProbeHitData hitData) {
        BlockEntity blockEntity;
        if (!(state.m_60734_() instanceof FieldProjectorBlock)) {
            return;
        }
        if (FieldProjectorBlock.isActive(state) && (blockEntity = level.m_7702_(hitData.getPos())) instanceof FieldProjectorEntity) {
            FieldProjectorEntity mFieldEntity = (FieldProjectorEntity)blockEntity;
            mFieldEntity.getCapability(CCCapabilities.MINIATURIZATION_FIELD).ifPresent(field -> {
                IMiniaturizationRecipe recipe = field.getCurrentRecipe().orElse(null);
                IProbeInfo recipeProgress = info.vertical(info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER).spacing(1));
                IProbeInfo group = recipeProgress.horizontal(info.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
                if (recipe != null) {
                    int progress = field.getProgress();
                    Set<ItemStack> possible = recipe.getCatalyst().getPossible();
                    group.item(possible.size() > 1 ? (ItemStack)possible.stream().findAny().get() : (ItemStack)possible.stream().findFirst().get());
                    group.icon(new ResourceLocation("compactcrafting", "textures/gui/jei-arrow-outputs.png"), 0, 0, 24, 19, info.defaultIconStyle().textureHeight(19).textureWidth(24).height(19).width(24));
                    for (ItemStack out : recipe.getOutputs()) {
                        group.item(out);
                    }
                    recipeProgress.progress(1, 1, info.defaultProgressStyle().showText(false).borderColor(0).backgroundColor(0).height(0).width(110).filledColor(0).alternateFilledColor(0)).progress(progress, recipe.getCraftingTime(), info.defaultProgressStyle().height(5).width(100).showText(false).filledColor(-3355444).alternateFilledColor(-3355444).backgroundColor(Color.rgb((int)255, (int)250, (int)250, (int)50)).borderColor(0));
                    if (field.getCraftingState() == EnumCraftingState.MATCHED && progress == 0) {
                        recipeProgress.text((Component)Component.m_237115_((String)"compactcrafting.top.awaiting_catalyst"));
                    } else if (mode == ProbeMode.EXTENDED) {
                        recipeProgress.text((Component)Component.m_237110_((String)"compactcrafting.top.progress", (Object[])new Object[]{progress, recipe.getCraftingTime()}));
                    }
                }
            });
        }
    }
}

