/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.compat.jei;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import dev.compactmods.crafting.CompactCrafting;
import dev.compactmods.crafting.api.components.IRecipeBlockComponent;
import dev.compactmods.crafting.api.recipe.layers.IRecipeLayer;
import dev.compactmods.crafting.client.fakeworld.RenderingWorld;
import dev.compactmods.crafting.client.ui.ScreenArea;
import dev.compactmods.crafting.core.CCBlocks;
import dev.compactmods.crafting.recipes.MiniaturizationRecipe;
import dev.compactmods.crafting.recipes.components.BlockComponent;
import dev.compactmods.crafting.util.BlockSpaceUtil;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.lwjgl.BufferUtils;

public class JeiMiniaturizationCraftingCategory
implements IRecipeCategory<MiniaturizationRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("compactcrafting", "miniaturization");
    public static final RecipeType<MiniaturizationRecipe> RECIPE_TYPE = new RecipeType(UID, MiniaturizationRecipe.class);
    private final IDrawable icon;
    private final BlockRenderDispatcher blocks;
    private RenderingWorld previewLevel;
    private IGuiHelper guiHelper;
    private final IDrawableStatic background;
    private final IDrawableStatic slotDrawable;
    private final IDrawableStatic arrowOutputs;
    private boolean singleLayer = false;
    private int singleLayerOffset = 0;
    private boolean debugMode = false;
    private ScreenArea explodeToggle = new ScreenArea(30, 75, 10, 10);
    private ScreenArea layerUp = new ScreenArea(55, 75, 10, 10);
    private ScreenArea layerSwap = new ScreenArea(70, 75, 10, 10);
    private ScreenArea layerDown = new ScreenArea(85, 75, 10, 10);
    private boolean exploded = false;
    private double explodeMulti = 1.0;
    private final MutableComponent MATERIAL_COMPONENT = Component.m_237115_((String)"compactcrafting.jei.miniaturization.component").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC);
    private final MutableComponent CATALYST = Component.m_237115_((String)"compactcrafting.jei.miniaturization.catalyst").m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.ITALIC);

    public JeiMiniaturizationCraftingCategory(IGuiHelper guiHelper) {
        int width = 172;
        int height = 129;
        this.guiHelper = guiHelper;
        this.background = guiHelper.createBlankDrawable(width, height);
        this.slotDrawable = guiHelper.getSlotDrawable();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CCBlocks.FIELD_PROJECTOR_BLOCK.get()));
        this.arrowOutputs = guiHelper.createDrawable(new ResourceLocation("compactcrafting", "textures/gui/jei-arrow-outputs.png"), 0, 0, 24, 19);
        this.blocks = Minecraft.m_91087_().m_91289_();
        this.previewLevel = null;
    }

    public RecipeType<MiniaturizationRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"compactcrafting.jei.miniaturization.title");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder layout, MiniaturizationRecipe recipe, IFocusGroup focuses) {
        this.previewLevel = new RenderingWorld(recipe);
        this.singleLayer = false;
        this.singleLayerOffset = 0;
        try {
            this.addMaterialSlots(recipe, layout);
            this.addCatalystSlots(recipe, layout);
            int fromRightEdge = this.background.getWidth() - 36 - 5;
            this.addOutputSlots(recipe, layout, fromRightEdge);
        }
        catch (Exception ex) {
            CompactCrafting.LOGGER.error((Object)recipe.getRecipeIdentifier());
            CompactCrafting.LOGGER.error("Error displaying recipe", (Throwable)ex);
        }
    }

    private IRecipeSlotBuilder addCatalystSlots(MiniaturizationRecipe recipe, IRecipeLayoutBuilder layout) {
        IRecipeSlotBuilder catalystSlot = layout.addSlot(RecipeIngredientRole.CATALYST, 1, 1).setBackground((IDrawable)this.slotDrawable, -1, -1);
        if (!recipe.getCatalyst().matches(ItemStack.f_41583_)) {
            ((IRecipeSlotBuilder)catalystSlot.addItemStacks(new ArrayList<ItemStack>(recipe.getCatalyst().getPossible()))).addTooltipCallback((slots, c) -> c.add(this.CATALYST));
        }
        return catalystSlot;
    }

    private void addMaterialSlots(MiniaturizationRecipe recipe, IRecipeLayoutBuilder layout) {
        AtomicInteger inputOffset = new AtomicInteger();
        int GUTTER_X = 5;
        int OFFSET_Y = 64;
        recipe.getComponentTotals().entrySet().stream().filter(comp -> (Integer)comp.getValue() > 0).sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEach(comp -> {
            String component = (String)comp.getKey();
            int required = (Integer)comp.getValue();
            int finalInputOffset = inputOffset.get();
            IRecipeBlockComponent bs = recipe.getComponents().getBlock(component).get();
            if (bs instanceof BlockComponent) {
                BlockComponent bsc = (BlockComponent)bs;
                Item bi = bsc.getBlock().m_5456_();
                int slotX = 5 + finalInputOffset % 9 * 18;
                int slotY = 88 + finalInputOffset / 9 * 18;
                IRecipeSlotBuilder slot = layout.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).setBackground((IDrawable)this.slotDrawable, -1, -1);
                if (bi != Items.f_41852_) {
                    slot.addItemStack(new ItemStack((ItemLike)bi, required));
                    slot.addTooltipCallback((slots, c) -> c.add(this.MATERIAL_COMPONENT));
                    inputOffset.getAndIncrement();
                }
            }
        });
        for (int i = inputOffset.get(); i < 18; ++i) {
            int slotX = 5 + i % 9 * 18;
            int slotY = 88 + i / 9 * 18;
            layout.addSlot(RecipeIngredientRole.INPUT, slotX, slotY).setBackground((IDrawable)this.slotDrawable, -1, -1);
        }
    }

    private void addOutputSlots(MiniaturizationRecipe recipe, IRecipeLayoutBuilder layout, int GUTTER_X) {
        ItemStack[] out = recipe.getOutputs();
        for (int outputNum = 0; outputNum < 6; ++outputNum) {
            int x = 18 * (outputNum % 2) + GUTTER_X + 1;
            int y = 18 * (outputNum / 2) + 8 + 1;
            IRecipeSlotBuilder slot = layout.addSlot(RecipeIngredientRole.OUTPUT, x, y).setBackground((IDrawable)this.slotDrawable, -1, -1);
            if (outputNum >= out.length) continue;
            slot.addItemStack(out[outputNum]);
        }
    }

    public List<Component> getTooltipStrings(MiniaturizationRecipe recipe, IRecipeSlotsView slots, double mouseX, double mouseY) {
        if (this.explodeToggle.contains(mouseX, mouseY)) {
            if (!this.exploded) {
                return List.of(Component.m_237115_((String)"compactcrafting.jei.toggle_exploded_view"));
            }
            return List.of(Component.m_237115_((String)"compactcrafting.jei.toggle_condensed_view"));
        }
        if (this.layerSwap.contains(mouseX, mouseY)) {
            if (this.singleLayer) {
                return List.of(Component.m_237115_((String)"compactcrafting.jei.all_layers_mode"));
            }
            return List.of(Component.m_237115_((String)"compactcrafting.jei.single_layer_mode"));
        }
        if (this.layerUp.contains(mouseX, mouseY) && this.singleLayer && (double)this.singleLayerOffset < recipe.getDimensions().m_82376_() - 1.0) {
            return List.of(Component.m_237115_((String)"compactcrafting.jei.layer_up"));
        }
        if (this.layerDown.contains(mouseX, mouseY) && this.singleLayer && this.singleLayerOffset > 0) {
            return List.of(Component.m_237115_((String)"compactcrafting.jei.layer_down"));
        }
        return Collections.emptyList();
    }

    public boolean handleInput(MiniaturizationRecipe recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (input.m_84868_() == InputConstants.Type.MOUSE && input.m_84873_() == 0) {
            SoundManager handler = Minecraft.m_91087_().m_91106_();
            if (this.explodeToggle.contains(mouseX, mouseY)) {
                this.explodeMulti = this.exploded ? 1.0 : 1.6;
                this.exploded = !this.exploded;
                handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            if (this.layerSwap.contains(mouseX, mouseY)) {
                this.singleLayer = !this.singleLayer;
                handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            if (this.layerUp.contains(mouseX, mouseY) && this.singleLayer) {
                if ((double)this.singleLayerOffset < recipe.getDimensions().m_82376_() - 1.0) {
                    handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                    ++this.singleLayerOffset;
                }
                return true;
            }
            if (this.layerDown.contains(mouseX, mouseY) && this.singleLayer) {
                if (this.singleLayerOffset > 0) {
                    handler.m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                    --this.singleLayerOffset;
                }
                return true;
            }
        }
        return false;
    }

    private void drawScaledTexture(PoseStack matrixStack, ResourceLocation texture, ScreenArea area, float u, float v, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        RenderSystem.m_69482_();
        GuiComponent.m_93160_((PoseStack)matrixStack, (int)area.x, (int)area.y, (int)area.width, (int)area.height, (float)u, (float)v, (int)uWidth, (int)vHeight, (int)textureWidth, (int)textureHeight);
    }

    public void draw(MiniaturizationRecipe recipe, IRecipeSlotsView slots, PoseStack pose, double mouseX, double mouseY) {
        AABB dims = recipe.getDimensions();
        Window mainWindow = Minecraft.m_91087_().m_91268_();
        this.drawScaledTexture(pose, new ResourceLocation("compactcrafting", "textures/gui/jei-arrow-field.png"), new ScreenArea(7, 20, 17, 22), 0.0f, 0.0f, 17, 22, 17, 22);
        this.drawScaledTexture(pose, new ResourceLocation("compactcrafting", "textures/gui/jei-arrow-outputs.png"), new ScreenArea(100, 25, 24, 19), 0.0f, 0.0f, 24, 19, 24, 19);
        int scissorX = 27;
        int scissorY = 0;
        double guiScaleFactor = mainWindow.m_85449_();
        ScreenArea scissorBounds = new ScreenArea(scissorX, scissorY, 70, 70);
        this.renderPreviewControls(pose, dims);
        if (this.previewLevel != null) {
            this.renderRecipe(recipe, pose, dims, guiScaleFactor, scissorBounds);
        }
    }

    private void renderRecipe(MiniaturizationRecipe recipe, PoseStack mx, AABB dims, double guiScaleFactor, ScreenArea scissorBounds) {
        try {
            GuiComponent.m_93172_((PoseStack)mx, (int)scissorBounds.x, (int)scissorBounds.y, (int)(scissorBounds.x + scissorBounds.width), (int)scissorBounds.height, (int)-12566464);
            MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
            double scale = Minecraft.m_91087_().m_91268_().m_85449_();
            Matrix4f matrix = mx.m_85850_().m_85861_();
            FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
            matrix.m_27650_(buf);
            Vec3 translation = new Vec3((double)buf.get(12) * scale, (double)buf.get(13) * scale, (double)buf.get(14) * scale);
            scissorBounds.x = (int)((double)scissorBounds.x * scale);
            scissorBounds.y = (int)((double)scissorBounds.y * scale);
            scissorBounds.width = (int)((double)scissorBounds.width * scale);
            scissorBounds.height = (int)((double)scissorBounds.height * scale);
            int scissorX = Math.round(Math.round(translation.f_82479_ + (double)scissorBounds.x));
            int scissorY = Math.round(Math.round((double)(Minecraft.m_91087_().m_91268_().m_85442_() - scissorBounds.y - scissorBounds.height) - translation.f_82480_));
            int scissorW = Math.round(scissorBounds.width);
            int scissorH = Math.round(scissorBounds.height);
            RenderSystem.m_69488_((int)scissorX, (int)scissorY, (int)scissorW, (int)scissorH);
            mx.m_85836_();
            mx.m_85837_(62.0, (double)(scissorBounds.y + 35), 100.0);
            Vec3 dimsVec = new Vec3(dims.m_82362_(), dims.m_82376_(), dims.m_82385_());
            float recipeAvgDim = (float)dimsVec.m_82553_();
            float previewScale = (float)((3.0 + Math.exp(3.0f - recipeAvgDim / 5.0f)) / this.explodeMulti);
            mx.m_85841_(previewScale, -previewScale, previewScale);
            this.drawActualRecipe(recipe, mx, dims, buffers);
            mx.m_85849_();
            buffers.m_109911_();
            RenderSystem.m_69471_();
        }
        catch (Exception ex) {
            CompactCrafting.LOGGER.warn((Object)ex);
        }
    }

    private void drawActualRecipe(MiniaturizationRecipe recipe, PoseStack mx, AABB dims, MultiBufferSource.BufferSource buffers) {
        double gameTime = Minecraft.m_91087_().f_91073_.m_46467_();
        double test = Math.toDegrees(gameTime) / 15.0;
        mx.m_85845_(new Quaternion(35.0f, (float)(-test), 0.0f, true));
        double ySize = recipe.getDimensions().m_82376_();
        int[] renderLayers = !this.singleLayer ? IntStream.range(0, (int)ySize).toArray() : new int[]{this.singleLayerOffset};
        mx.m_85837_(-(dims.m_82362_() / 2.0) * this.explodeMulti - 0.5, -(dims.m_82376_() / 2.0) * this.explodeMulti - 0.5, -(dims.m_82385_() / 2.0) * this.explodeMulti - 0.5);
        for (int y : renderLayers) {
            recipe.getLayer(y).ifPresent(l -> this.renderRecipeLayer(recipe, mx, buffers, (IRecipeLayer)l, y));
        }
    }

    private void renderPreviewControls(PoseStack mx, AABB dims) {
        mx.m_85836_();
        mx.m_85837_(0.0, 0.0, 10.0);
        ResourceLocation sprites = new ResourceLocation("compactcrafting", "textures/gui/jei-sprites.png");
        if (this.exploded) {
            this.drawScaledTexture(mx, sprites, this.explodeToggle, 20.0f, 0.0f, 20, 20, 120, 20);
        } else {
            this.drawScaledTexture(mx, sprites, this.explodeToggle, 0.0f, 0.0f, 20, 20, 120, 20);
        }
        if (this.singleLayer) {
            this.drawScaledTexture(mx, sprites, this.layerSwap, 60.0f, 0.0f, 20, 20, 120, 20);
        } else {
            this.drawScaledTexture(mx, sprites, this.layerSwap, 40.0f, 0.0f, 20, 20, 120, 20);
        }
        if (this.singleLayer) {
            if ((double)this.singleLayerOffset < dims.m_82376_() - 1.0) {
                this.drawScaledTexture(mx, sprites, this.layerUp, 80.0f, 0.0f, 20, 20, 120, 20);
            }
            if (this.singleLayerOffset > 0) {
                this.drawScaledTexture(mx, sprites, this.layerDown, 100.0f, 0.0f, 20, 20, 120, 20);
            }
        }
        mx.m_85849_();
    }

    private void renderRecipeLayer(MiniaturizationRecipe recipe, PoseStack mx, MultiBufferSource.BufferSource buffers, IRecipeLayer l, int layerY) {
        mx.m_85836_();
        AABB layerBounds = BlockSpaceUtil.getLayerBounds(recipe.getDimensions(), layerY);
        BlockPos.m_121921_((AABB)layerBounds).forEach(filledPos -> {
            mx.m_85836_();
            mx.m_85837_(((double)filledPos.m_123341_() + 0.5) * this.explodeMulti, ((double)layerY + 0.5) * this.explodeMulti, ((double)filledPos.m_123343_() + 0.5) * this.explodeMulti);
            BlockPos zeroedPos = filledPos.m_6625_(layerY);
            Optional<String> componentForPosition = l.getComponentForPosition(zeroedPos);
            componentForPosition.flatMap(recipe.getComponents()::getBlock).ifPresent(comp -> this.renderComponent(mx, buffers, (IRecipeBlockComponent)comp, (BlockPos)filledPos));
            mx.m_85849_();
        });
        mx.m_85849_();
    }

    private void renderComponent(PoseStack mx, MultiBufferSource.BufferSource buffers, IRecipeBlockComponent state, BlockPos filledPos) {
        BlockEntity be;
        if (state.didErrorRendering()) {
            return;
        }
        BlockState state1 = state.getRenderState();
        ModelData data = ModelData.EMPTY;
        if (this.previewLevel != null && state1.m_155947_() && (be = this.previewLevel.m_7702_(filledPos)) != null) {
            data = be.getModelData();
        }
        try {
            this.blocks.renderSingleBlock(state1, mx, (MultiBufferSource)buffers, 0xF00000, OverlayTexture.f_118083_, data, null);
        }
        catch (Exception e) {
            state.markRenderingErrored();
            CompactCrafting.LOGGER.warn("Error rendering block in preview: {}", (Object)state1);
            CompactCrafting.LOGGER.error("Stack Trace", (Throwable)e);
        }
    }
}

