/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.compactmods.crafting.api.field.IMiniaturizationField;
import dev.compactmods.crafting.core.CCCapabilities;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FieldInfoCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> create() {
        LiteralArgumentBuilder field = Commands.m_82127_((String)"field");
        field.then(Commands.m_82127_((String)"ref").then(Commands.m_82129_((String)"block", (ArgumentType)BlockPosArgument.m_118239_()).executes(FieldInfoCommand::byReference)));
        field.then(Commands.m_82127_((String)"center").then(Commands.m_82129_((String)"center", (ArgumentType)BlockPosArgument.m_118239_()).executes(FieldInfoCommand::byCenter)));
        return field;
    }

    private static int byCenter(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_118242_(ctx, (String)"center");
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerLevel level = src.m_81372_();
        level.getCapability(CCCapabilities.FIELDS).ifPresent(fields -> {
            if (!fields.hasActiveField(pos)) {
                src.m_81352_((Component)Component.m_237110_((String)"messages.compactcrafting.no_field_found", (Object[])new Object[]{pos}));
                return;
            }
            fields.get(pos).ifPresent(field -> FieldInfoCommand.outputStdFieldInfo(src, field));
        });
        return 0;
    }

    private static int byReference(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_118242_(ctx, (String)"block");
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerLevel level = src.m_81372_();
        if (level.m_8055_(pos).m_155947_()) {
            BlockEntity ent = level.m_7702_(pos);
            if (ent == null) {
                src.m_81352_((Component)Component.m_237110_((String)"messages.compactcrafting.no_field_cap", (Object[])new Object[]{pos}));
                return 0;
            }
            ent.getCapability(CCCapabilities.MINIATURIZATION_FIELD).ifPresent(field -> FieldInfoCommand.outputStdFieldInfo(src, field));
        } else {
            src.m_81352_((Component)Component.m_237110_((String)"messages.compactcrafting.no_field_cap", (Object[])new Object[]{pos}));
        }
        return 0;
    }

    private static void outputStdFieldInfo(CommandSourceStack src, IMiniaturizationField field) {
        src.m_81354_((Component)Component.m_237113_((String)("Center: " + field.getCenter().toString())), false);
        src.m_81354_((Component)Component.m_237113_((String)("Size: " + field.getFieldSize().getName())), false);
        field.getCurrentRecipe().ifPresent(rec -> src.m_81354_((Component)Component.m_237113_((String)("Recipe: " + rec.getRecipeIdentifier())), false));
    }
}

