/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.compactmods.crafting.client.render.EnumCubeFaceCorner;
import dev.compactmods.crafting.client.render.RotationSpeed;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class CubeRenderHelper {
    public static void addColoredVertex(VertexConsumer renderer, PoseStack stack, int color, Vec3 position) {
        renderer.m_85982_(stack.m_85850_().m_85861_(), (float)position.m_7096_(), (float)position.m_7098_(), (float)position.m_7094_()).m_6122_(FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color), FastColor.ARGB32.m_13655_((int)color)).m_85977_(stack.m_85850_().m_85864_(), 0.0f, 0.0f, 0.0f).m_5752_();
    }

    public static void drawCubeFace(VertexConsumer builder, PoseStack mx, AABB cube, int color, Direction face) {
        Vec3 TOP_LEFT = CubeRenderHelper.getCubeFacePoint(cube, face, EnumCubeFaceCorner.TOP_LEFT);
        Vec3 TOP_RIGHT = CubeRenderHelper.getCubeFacePoint(cube, face, EnumCubeFaceCorner.TOP_RIGHT);
        Vec3 BOTTOM_LEFT = CubeRenderHelper.getCubeFacePoint(cube, face, EnumCubeFaceCorner.BOTTOM_LEFT);
        Vec3 BOTTOM_RIGHT = CubeRenderHelper.getCubeFacePoint(cube, face, EnumCubeFaceCorner.BOTTOM_RIGHT);
        if (BOTTOM_RIGHT == Vec3.f_82478_) {
            return;
        }
        Vec3i normal = Vec3i.f_123288_;
        switch (face) {
            case UP: {
                normal = new Vec3i(0, 1, 0);
                break;
            }
            case DOWN: {
                normal = new Vec3i(0, -1, 0);
                break;
            }
            case NORTH: {
                normal = new Vec3i(0, 0, 1);
                break;
            }
            case SOUTH: {
                normal = new Vec3i(0, 0, -1);
                break;
            }
            case WEST: {
                normal = new Vec3i(1, 0, 0);
                break;
            }
            case EAST: {
                normal = new Vec3i(-1, 0, 0);
            }
        }
        Vec3i oppNormal = normal.m_142393_(-1);
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        int a = 50;
        builder.m_85982_(mx.m_85850_().m_85861_(), (float)BOTTOM_LEFT.m_7096_(), (float)BOTTOM_LEFT.m_7098_(), (float)BOTTOM_LEFT.m_7094_()).m_6122_(r, g, b, 50).m_85977_(mx.m_85850_().m_85864_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        builder.m_85982_(mx.m_85850_().m_85861_(), (float)BOTTOM_RIGHT.m_7096_(), (float)BOTTOM_RIGHT.m_7098_(), (float)BOTTOM_RIGHT.m_7094_()).m_6122_(r, g, b, 50).m_85977_(mx.m_85850_().m_85864_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        builder.m_85982_(mx.m_85850_().m_85861_(), (float)TOP_RIGHT.m_7096_(), (float)TOP_RIGHT.m_7098_(), (float)TOP_RIGHT.m_7094_()).m_6122_(r, g, b, 50).m_85977_(mx.m_85850_().m_85864_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
        builder.m_85982_(mx.m_85850_().m_85861_(), (float)TOP_LEFT.m_7096_(), (float)TOP_LEFT.m_7098_(), (float)TOP_LEFT.m_7094_()).m_6122_(r, g, b, 50).m_85977_(mx.m_85850_().m_85864_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }

    public static Vec3 getCubeFacePoint(AABB cube, Direction face, EnumCubeFaceCorner corner) {
        Vec3 BOTTOM_RIGHT = null;
        Vec3 TOP_RIGHT = null;
        Vec3 TOP_LEFT = null;
        Vec3 BOTTOM_LEFT = null;
        switch (face) {
            case NORTH: {
                BOTTOM_LEFT = new Vec3(cube.f_82291_, cube.f_82289_, cube.f_82290_);
                BOTTOM_RIGHT = new Vec3(cube.f_82288_, cube.f_82289_, cube.f_82290_);
                TOP_LEFT = new Vec3(cube.f_82291_, cube.f_82292_, cube.f_82290_);
                TOP_RIGHT = new Vec3(cube.f_82288_, cube.f_82292_, cube.f_82290_);
                break;
            }
            case SOUTH: {
                BOTTOM_RIGHT = new Vec3(cube.f_82291_, cube.f_82289_, cube.f_82293_);
                TOP_RIGHT = new Vec3(cube.f_82291_, cube.f_82292_, cube.f_82293_);
                TOP_LEFT = new Vec3(cube.f_82288_, cube.f_82292_, cube.f_82293_);
                BOTTOM_LEFT = new Vec3(cube.f_82288_, cube.f_82289_, cube.f_82293_);
                break;
            }
            case WEST: {
                BOTTOM_RIGHT = new Vec3(cube.f_82288_, cube.f_82289_, cube.f_82293_);
                TOP_RIGHT = new Vec3(cube.f_82288_, cube.f_82292_, cube.f_82293_);
                TOP_LEFT = new Vec3(cube.f_82288_, cube.f_82292_, cube.f_82290_);
                BOTTOM_LEFT = new Vec3(cube.f_82288_, cube.f_82289_, cube.f_82290_);
                break;
            }
            case EAST: {
                BOTTOM_RIGHT = new Vec3(cube.f_82291_, cube.f_82289_, cube.f_82290_);
                TOP_RIGHT = new Vec3(cube.f_82291_, cube.f_82292_, cube.f_82290_);
                TOP_LEFT = new Vec3(cube.f_82291_, cube.f_82292_, cube.f_82293_);
                BOTTOM_LEFT = new Vec3(cube.f_82291_, cube.f_82289_, cube.f_82293_);
                break;
            }
            case UP: {
                BOTTOM_RIGHT = new Vec3(cube.f_82288_, cube.f_82292_, cube.f_82290_);
                TOP_RIGHT = new Vec3(cube.f_82288_, cube.f_82292_, cube.f_82293_);
                TOP_LEFT = new Vec3(cube.f_82291_, cube.f_82292_, cube.f_82293_);
                BOTTOM_LEFT = new Vec3(cube.f_82291_, cube.f_82292_, cube.f_82290_);
                break;
            }
            case DOWN: {
                BOTTOM_RIGHT = new Vec3(cube.f_82288_, cube.f_82289_, cube.f_82293_);
                TOP_RIGHT = new Vec3(cube.f_82288_, cube.f_82289_, cube.f_82290_);
                TOP_LEFT = new Vec3(cube.f_82291_, cube.f_82289_, cube.f_82290_);
                BOTTOM_LEFT = new Vec3(cube.f_82291_, cube.f_82289_, cube.f_82293_);
            }
        }
        switch (corner) {
            case TOP_LEFT: {
                return TOP_LEFT;
            }
            case TOP_RIGHT: {
                return TOP_RIGHT;
            }
            case BOTTOM_LEFT: {
                return BOTTOM_LEFT;
            }
            case BOTTOM_RIGHT: {
                return BOTTOM_RIGHT;
            }
        }
        return Vec3.f_82478_;
    }

    public static double getScanLineHeight(AABB cube, double gameTime) {
        double zAngle = (Math.sin(Math.toDegrees(gameTime) / (double)(-RotationSpeed.MEDIUM.getSpeed())) + 1.0) / 2.0 * cube.m_82376_();
        double scanHeight = cube.f_82289_ + zAngle;
        return scanHeight;
    }

    public static Vec3 getScanLineRight(Direction face, AABB cube, double gameTime) {
        double scanHeight = CubeRenderHelper.getScanLineHeight(cube, gameTime);
        switch (face) {
            case NORTH: {
                return new Vec3(cube.f_82288_, scanHeight, cube.f_82290_);
            }
            case SOUTH: {
                return new Vec3(cube.f_82291_, scanHeight, cube.f_82293_);
            }
            case WEST: {
                return new Vec3(cube.f_82288_, scanHeight, cube.f_82293_);
            }
            case EAST: {
                return new Vec3(cube.f_82291_, scanHeight, cube.f_82290_);
            }
        }
        return Vec3.f_82478_;
    }

    public static Vec3 getScanLineLeft(Direction face, AABB cube, double gameTime) {
        double scanHeight = CubeRenderHelper.getScanLineHeight(cube, gameTime);
        switch (face) {
            case NORTH: {
                return new Vec3(cube.f_82291_, scanHeight, cube.f_82290_);
            }
            case SOUTH: {
                return new Vec3(cube.f_82288_, scanHeight, cube.f_82293_);
            }
            case WEST: {
                return new Vec3(cube.f_82288_, scanHeight, cube.f_82290_);
            }
            case EAST: {
                return new Vec3(cube.f_82291_, scanHeight, cube.f_82293_);
            }
        }
        return Vec3.f_82478_;
    }
}

