/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.api.field;

import dev.compactmods.crafting.api.EnumCraftingState;
import dev.compactmods.crafting.api.field.IFieldListener;
import dev.compactmods.crafting.api.field.MiniaturizationFieldSize;
import dev.compactmods.crafting.api.recipe.IMiniaturizationRecipe;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public interface IMiniaturizationField
extends INBTSerializable<Tag> {
    default public void dispose() {
    }

    public AABB getBounds();

    public MiniaturizationFieldSize getFieldSize();

    public BlockPos getCenter();

    public void setCenter(BlockPos var1);

    public void setSize(MiniaturizationFieldSize var1);

    public int getProgress();

    default public Stream<BlockPos> getProjectorPositions() {
        return Stream.empty();
    }

    public Optional<IMiniaturizationRecipe> getCurrentRecipe();

    public void clearRecipe();

    public EnumCraftingState getCraftingState();

    public void setCraftingState(EnumCraftingState var1);

    default public void tick() {
    }

    public boolean isLoaded();

    default public void checkLoaded() {
    }

    public void fieldContentsChanged();

    public void setLevel(Level var1);

    public void registerListener(LazyOptional<IFieldListener> var1);

    default public CompoundTag serverData() {
        return new CompoundTag();
    }

    default public CompoundTag clientData() {
        CompoundTag data = new CompoundTag();
        data.m_128356_("center", this.getCenter().m_121878_());
        data.m_128359_("size", this.getFieldSize().name());
        data.m_128359_("state", this.getCraftingState().name());
        Optional<IMiniaturizationRecipe> currentRecipe = this.getCurrentRecipe();
        currentRecipe.ifPresent(r -> {
            CompoundTag recipe = new CompoundTag();
            recipe.m_128359_("id", r.getRecipeIdentifier().toString());
            recipe.m_128405_("progress", this.getProgress());
            data.m_128365_("recipe", (Tag)recipe);
        });
        return data;
    }

    default public void loadClientData(CompoundTag nbt) {
        this.setCenter(BlockPos.m_122022_((long)nbt.m_128454_("center")));
        this.setSize(MiniaturizationFieldSize.valueOf(nbt.m_128461_("size")));
        this.setCraftingState(EnumCraftingState.valueOf(nbt.m_128461_("state")));
        if (nbt.m_128441_("recipe")) {
            CompoundTag recipe = nbt.m_128469_("recipe");
            this.setRecipe(new ResourceLocation(recipe.m_128461_("id")));
            this.setProgress(recipe.m_128451_("progress"));
        }
    }

    public void setProgress(int var1);

    public void setRecipe(ResourceLocation var1);

    default public void handleDestabilize() {
    }

    public LazyOptional<IMiniaturizationField> getRef();

    public void setRef(LazyOptional<IMiniaturizationField> var1);

    public void enable();

    public void disable();

    public void checkRedstone();

    public boolean enabled();
}

