/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.common;

import com.illusivesoulworks.comforts.ComfortsConstants;
import com.illusivesoulworks.comforts.common.ComfortsEvents;
import com.illusivesoulworks.comforts.platform.Services;
import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import org.apache.commons.lang3.tuple.Pair;

public class ComfortsConfig {
    public static final SpectreConfigSpec SERVER_SPEC;
    public static final Server SERVER;
    private static final String CONFIG_PREFIX = "gui.comforts.config.";

    public static void reload() {
        ComfortsEvents.SLEEPING_BAG_EFFECTS.clear();
        ((List)ComfortsConfig.SERVER.sleepingBagEffects.get()).forEach(effect -> {
            String[] elements = effect.split(";");
            MobEffect mobEffect = Services.REGISTRY_UTIL.getMobEffect(new ResourceLocation(elements[0]));
            if (mobEffect == null) {
                return;
            }
            int duration = 0;
            int amp = 0;
            try {
                duration = Math.max(1, Math.min(Integer.parseInt(elements[1]), 1600));
                amp = Math.max(1, Math.min(Integer.parseInt(elements[2]), 4));
            }
            catch (Exception e) {
                ComfortsConstants.LOG.error("Problem parsing sleeping bag effects in config!", (Throwable)e);
            }
            ComfortsEvents.SLEEPING_BAG_EFFECTS.add(new MobEffectInstance(mobEffect, duration * 20, amp - 1));
        });
    }

    static {
        Pair specPair = new SpectreConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (SpectreConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final SpectreConfigSpec.BooleanValue autoUse;
        public final SpectreConfigSpec.BooleanValue wellRested;
        public final SpectreConfigSpec.DoubleValue sleepyFactor;
        public final SpectreConfigSpec.BooleanValue nightHammocks;
        public final SpectreConfigSpec.DoubleValue sleepingBagBreakage;
        public final SpectreConfigSpec.DoubleValue sleepingBagBreakageLuckMultiplier;
        public final SpectreConfigSpec.ConfigValue<List<String>> sleepingBagEffects;

        public Server(SpectreConfigSpec.Builder builder) {
            builder.push("server");
            this.autoUse = builder.comment("Set to true to automatically use sleeping bags when placed").translation("gui.comforts.config.autoUse").define("autoUse", true);
            this.wellRested = builder.comment("Set to true to prevent sleeping depending on how long you previously slept").translation("gui.comforts.config.wellRested").define("wellRested", false);
            this.sleepyFactor = builder.comment("If well rested is true, this value is used to determine how long you need before being able to sleep again (larger numbers = can sleep sooner)").translation("gui.comforts.config.sleepyFactor").defineInRange("sleepyFactor", 2.0, 1.0, 20.0);
            this.nightHammocks = builder.comment("Set to true to enable sleeping in hammocks at night").translation("gui.comforts.config.nightHammocks").define("nightHammocks", false);
            this.sleepingBagBreakage = builder.comment("The chance that a sleeping bag will break upon usage").translation("gui.comforts.config.sleepingBagBreakage").defineInRange("sleepingBagBreakage", 0.0, 0.0, 1.0);
            this.sleepingBagBreakageLuckMultiplier = builder.comment("The value that will be multiplied by a player's luck then added/subtracted from the sleepingBagBreakage value").translation("gui.comforts.config.sleepingBagBreakageLuckMultiplier").defineInRange("sleepingBagBreakageLuckMultiplier", 0.0, -1.0, 1.0);
            this.sleepingBagEffects = builder.comment("List of debuffs to apply to players after using the sleeping bag\nFormat: effect;duration(secs);power").translation("gui.comforts.config.sleepingBagDebuffs").define("sleepingBagDebuffs", new ArrayList());
            builder.pop();
        }
    }
}

