/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.heart.Heart;
import terrails.colorfulhearts.heart.HeartPiece;
import terrails.colorfulhearts.heart.HeartType;

public class TabHeartRenderer {
    public static final TabHeartRenderer INSTANCE = new TabHeartRenderer();
    private final Minecraft client = Minecraft.m_91087_();
    private Heart[] hearts;
    private int lastHealth;
    private int lastDisplayHealth;

    public void renderPlayerListHud(int y, int x, int offset, PoseStack poseStack, int health, PlayerInfo playerInfo) {
        if (health != this.lastHealth || playerInfo.m_105344_() != this.lastDisplayHealth || this.hearts == null) {
            int value = Math.max(health, playerInfo.m_105344_());
            List<HeartPiece> healthColors = HeartPiece.getHeartPiecesForType(HeartType.NORMAL, false);
            List<HeartPiece> absorptionColors = HeartPiece.getHeartPiecesForType(HeartType.NORMAL, true);
            this.hearts = Heart.calculateHearts(0, value, value, healthColors, absorptionColors, false);
            this.lastHealth = health;
            this.lastDisplayHealth = playerInfo.m_105344_();
            CColorfulHearts.LOGGER.debug("Successfully updated tab hearts.\n{}", (Object)Arrays.toString(this.hearts));
        }
        health = Math.min(health, 20);
        int displayHealth = Math.min(playerInfo.m_105344_(), 20);
        int displayHealthHearts = Mth.m_14165_((double)((double)displayHealth / 2.0));
        boolean blinking = playerInfo.m_105346_() > (long)this.client.f_91065_.m_93079_() && (playerInfo.m_105346_() - (long)this.client.f_91065_.m_93079_()) / 3L % 2L == 1L;
        int spacingDivisor = Math.max(health, displayHealth) / 2;
        int spacingMultiplier = Mth.m_14143_((float)Math.min((float)(offset - x - 4) / (float)spacingDivisor, 9.0f));
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        RenderSystem.m_69478_();
        for (int i = 0; i < this.hearts.length; ++i) {
            Heart heart = this.hearts[i];
            if (heart == null) continue;
            int xPos = x + i % 10 * spacingMultiplier;
            boolean blinkingHeart = blinking && i < displayHealthHearts;
            heart.draw(poseStack, xPos, y, blinking, blinkingHeart, HeartType.NORMAL);
        }
        RenderSystem.m_69461_();
    }
}

