/*
 * Decompiled with CFR 0.152.
 */
package terrails.colorfulhearts.heart;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import terrails.colorfulhearts.CColorfulHearts;
import terrails.colorfulhearts.LoaderExpectPlatform;
import terrails.colorfulhearts.config.Configuration;
import terrails.colorfulhearts.heart.HeartPiece;
import terrails.colorfulhearts.heart.HeartType;
import terrails.colorfulhearts.render.RenderUtils;

public class Heart {
    private static final Set<Heart> HEART_CACHE = new HashSet<Heart>();
    public static final Heart CONTAINER_FULL = new Heart(true, null, null);
    public static final Heart CONTAINER_HALF = new Heart(false, null, null);
    private final boolean isBackgroundFull;
    private final HeartPiece firstHalf;
    private final HeartPiece secondHalf;

    private Heart(boolean isBackgroundFull, HeartPiece firstHalf, HeartPiece secondHalf) {
        this.isBackgroundFull = isBackgroundFull;
        this.firstHalf = firstHalf;
        this.secondHalf = secondHalf;
    }

    public static Heart full(HeartPiece firstHalf, HeartPiece secondHalf) {
        if (firstHalf == null || secondHalf == null) {
            CColorfulHearts.LOGGER.error("Something went very wrong with heart creation. HeartPiece cannot be null, returning heart container to prevent crashes...");
            return CONTAINER_FULL;
        }
        Optional<Heart> optional = HEART_CACHE.stream().filter(heart -> heart.isBackgroundFull && Objects.equals(heart.firstHalf, firstHalf) && Objects.equals(heart.secondHalf, secondHalf)).findAny();
        return optional.orElseGet(() -> {
            Heart heart = new Heart(true, firstHalf, secondHalf);
            HEART_CACHE.add(heart);
            return heart;
        });
    }

    public static Heart full(HeartPiece heartPiece) {
        if (heartPiece == null) {
            CColorfulHearts.LOGGER.error("Something went very wrong with heart creation. HeartPiece cannot be null, returning heart container to prevent crashes...");
            return CONTAINER_FULL;
        }
        Optional<Heart> optional = HEART_CACHE.stream().filter(heart -> heart.isBackgroundFull && Objects.equals(heart.firstHalf, heartPiece) && Objects.equals(heart.secondHalf, heartPiece)).findAny();
        return optional.orElseGet(() -> {
            Heart heart = new Heart(true, heartPiece, heartPiece);
            HEART_CACHE.add(heart);
            return heart;
        });
    }

    public static Heart half(HeartPiece heartPiece, boolean isBackgroundFull) {
        if (heartPiece == null) {
            CColorfulHearts.LOGGER.error("Something went very wrong with heart creation. HeartPiece cannot be null, returning heart container to prevent crashes...");
            return isBackgroundFull ? CONTAINER_FULL : CONTAINER_HALF;
        }
        Optional<Heart> optional = HEART_CACHE.stream().filter(heart -> heart.isBackgroundFull == isBackgroundFull && Objects.equals(heart.firstHalf, heartPiece) && heart.secondHalf == null).findAny();
        return optional.orElseGet(() -> {
            Heart heart = new Heart(isBackgroundFull, heartPiece, null);
            HEART_CACHE.add(heart);
            return heart;
        });
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Heart heart = (Heart)obj;
            return this.isBackgroundFull == heart.isBackgroundFull && Objects.equals(this.firstHalf, heart.firstHalf) && Objects.equals(this.secondHalf, heart.secondHalf);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.isBackgroundFull, this.firstHalf, this.secondHalf);
    }

    public String toString() {
        return "{isBackgroundFull=" + this.isBackgroundFull + ", firstHalf=" + this.firstHalf + ", secondHalf=" + this.secondHalf + "}";
    }

    public void draw(PoseStack poseStack, int xPos, int yPos, boolean blinkBackground, boolean blinkHeart, HeartType type) {
        boolean canBlink;
        Minecraft client = Minecraft.m_91087_();
        boolean hardcore = LoaderExpectPlatform.forcedHardcoreHearts() || client.f_91073_ != null && client.f_91073_.m_6106_().m_5466_();
        boolean bl = canBlink = Configuration.ABSORPTION.renderOverHealth.get() != false || this.firstHalf == null || !this.firstHalf.isAbsorption();
        if (this.isBackgroundFull) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
            RenderUtils.drawTexture(poseStack, xPos, yPos, 16 + (canBlink && blinkBackground ? 9 : 0), hardcore ? 45 : 0);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)CColorfulHearts.HALF_HEART_ICONS_LOCATION);
            RenderUtils.drawTexture(poseStack, xPos, yPos, 0, canBlink && blinkBackground ? 9 : 0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        }
        if (this.firstHalf != null) {
            if (this.secondHalf == null) {
                this.firstHalf.draw(poseStack, xPos, yPos, blinkHeart, hardcore, type, true);
            } else if (Objects.equals(this.firstHalf, this.secondHalf)) {
                this.firstHalf.draw(poseStack, xPos, yPos, blinkHeart, hardcore, type);
            } else {
                this.firstHalf.draw(poseStack, xPos, yPos, blinkHeart, hardcore, type, true);
                this.secondHalf.draw(poseStack, xPos, yPos, blinkHeart, hardcore, type, false);
            }
        }
    }

    public static Heart[] calculateHearts(int absorption, int health, int maxHealth, List<HeartPiece> healthColors, List<HeartPiece> absorptionColors, boolean absorptionSameRow) {
        int healthColorIndex = Math.max((int)((double)health / 20.0) % healthColors.size() - 1, 0);
        boolean hasTopHealth = health % 20 != 0 && health > 20;
        HeartPiece[] healthPieces = new HeartPiece[]{hasTopHealth ? healthColors.get((healthColorIndex + 1) % healthColors.size()) : null, healthColors.get(healthColorIndex)};
        int maxAbsorptionHearts = absorptionSameRow ? 20 : (maxHealth >= 19 ? 20 : 40 - maxHealth - maxHealth % 2);
        int absorptionColorIndex = Math.max(absorption / maxAbsorptionHearts % absorptionColors.size() - 1, 0);
        boolean hasTopAbsorption = absorption % maxAbsorptionHearts != 0 && absorption > maxAbsorptionHearts;
        HeartPiece[] absorptionPieces = new HeartPiece[]{hasTopAbsorption ? absorptionColors.get((absorptionColorIndex + 1) % absorptionColors.size()) : null, absorptionColors.get(absorptionColorIndex)};
        int topHealthCount = health > 20 ? health % 20 : 0;
        int bottomHealthCount = health <= 20 ? health : 20 - topHealthCount;
        int emptyHealthCount = health < 20 ? Math.min(20, maxHealth) - bottomHealthCount : 0;
        ArrayList<Heart> hearts = new ArrayList<Heart>();
        if (absorptionSameRow && absorption > 0 && absorption < 20) {
            int spaceAfterTopMostHealth = 20 - (health > 20 ? topHealthCount : bottomHealthCount);
            int overflownAbsorptionCount = absorption > spaceAfterTopMostHealth ? absorption - spaceAfterTopMostHealth : 0;
            int bottomAbsorptionCount = Math.min(absorption, spaceAfterTopMostHealth);
            emptyHealthCount = Math.max(0, emptyHealthCount - bottomAbsorptionCount);
            topHealthCount = Math.max(0, topHealthCount - overflownAbsorptionCount);
            bottomHealthCount = Math.max(0, bottomHealthCount - (health > 20 ? bottomAbsorptionCount : overflownAbsorptionCount));
            while (topHealthCount + bottomHealthCount + overflownAbsorptionCount + bottomAbsorptionCount + emptyHealthCount > 0) {
                if (overflownAbsorptionCount > 0) {
                    if (overflownAbsorptionCount > 1) {
                        hearts.add(Heart.full(absorptionPieces[1]));
                        overflownAbsorptionCount -= 2;
                        continue;
                    }
                    if (topHealthCount > 0) {
                        hearts.add(Heart.full(absorptionPieces[1], healthPieces[0]));
                        --overflownAbsorptionCount;
                        --topHealthCount;
                        continue;
                    }
                    if (bottomHealthCount > 0) {
                        hearts.add(Heart.full(absorptionPieces[1], healthPieces[1]));
                        --overflownAbsorptionCount;
                        --bottomHealthCount;
                        continue;
                    }
                    hearts.add(Heart.half(absorptionPieces[1], true));
                    --overflownAbsorptionCount;
                    --emptyHealthCount;
                    continue;
                }
                if (topHealthCount > 0) {
                    if (topHealthCount > 1) {
                        hearts.add(Heart.full(healthPieces[0]));
                        topHealthCount -= 2;
                        continue;
                    }
                    hearts.add(Heart.full(healthPieces[0], absorptionPieces[1]));
                    --topHealthCount;
                    --bottomAbsorptionCount;
                    continue;
                }
                if (health >= 20) {
                    if (bottomAbsorptionCount > 0) {
                        if (bottomAbsorptionCount > 1) {
                            hearts.add(Heart.full(absorptionPieces[1]));
                            bottomAbsorptionCount -= 2;
                            continue;
                        }
                        if (bottomHealthCount > 0) {
                            hearts.add(Heart.full(absorptionPieces[1], healthPieces[1]));
                            --bottomAbsorptionCount;
                            --bottomHealthCount;
                            continue;
                        }
                        if (emptyHealthCount <= 0) continue;
                        hearts.add(Heart.half(absorptionPieces[1], true));
                        --bottomAbsorptionCount;
                        --emptyHealthCount;
                        continue;
                    }
                    if (bottomHealthCount <= 0) continue;
                    hearts.add(Heart.full(healthPieces[1]));
                    bottomHealthCount -= 2;
                    continue;
                }
                if (bottomHealthCount > 0) {
                    if (bottomHealthCount > 1) {
                        hearts.add(Heart.full(healthPieces[1]));
                        bottomHealthCount -= 2;
                        continue;
                    }
                    if (bottomAbsorptionCount > 0) {
                        hearts.add(Heart.full(healthPieces[1], absorptionPieces[1]));
                        --bottomHealthCount;
                        --bottomAbsorptionCount;
                        continue;
                    }
                    if (emptyHealthCount > 0) {
                        hearts.add(Heart.half(healthPieces[1], true));
                        --bottomHealthCount;
                        --emptyHealthCount;
                        continue;
                    }
                    hearts.add(Heart.half(healthPieces[1], false));
                    --bottomHealthCount;
                    continue;
                }
                if (bottomAbsorptionCount > 0) {
                    if (bottomAbsorptionCount > 1) {
                        hearts.add(Heart.full(absorptionPieces[1]));
                        bottomAbsorptionCount -= 2;
                        continue;
                    }
                    if (emptyHealthCount > 0) {
                        hearts.add(Heart.half(absorptionPieces[1], true));
                        --bottomAbsorptionCount;
                        --emptyHealthCount;
                        continue;
                    }
                    hearts.add(Heart.half(absorptionPieces[1], false));
                    --bottomAbsorptionCount;
                    continue;
                }
                if (emptyHealthCount <= 0) continue;
                if (emptyHealthCount > 1) {
                    hearts.add(CONTAINER_FULL);
                    emptyHealthCount -= 2;
                    continue;
                }
                hearts.add(CONTAINER_HALF);
                --emptyHealthCount;
            }
        } else {
            int bottomAbsorptionCount;
            int topAbsorptionCount = absorption > maxAbsorptionHearts ? absorption % maxAbsorptionHearts : 0;
            int n = bottomAbsorptionCount = absorption <= maxAbsorptionHearts ? absorption : maxAbsorptionHearts - topAbsorptionCount;
            if (absorptionSameRow && absorption >= 20) {
                topHealthCount = 0;
                bottomHealthCount = 0;
                emptyHealthCount = 0;
            }
            while (topHealthCount + bottomHealthCount + emptyHealthCount + topAbsorptionCount + bottomAbsorptionCount > 0) {
                if (topHealthCount > 0) {
                    if (topHealthCount > 1) {
                        hearts.add(Heart.full(healthPieces[0]));
                        topHealthCount -= 2;
                        continue;
                    }
                    hearts.add(Heart.full(healthPieces[0], healthPieces[1]));
                    --topHealthCount;
                    --bottomHealthCount;
                    continue;
                }
                if (bottomHealthCount > 0) {
                    if (bottomHealthCount > 1) {
                        hearts.add(Heart.full(healthPieces[1]));
                        bottomHealthCount -= 2;
                        continue;
                    }
                    if (emptyHealthCount > 0) {
                        hearts.add(Heart.half(healthPieces[1], true));
                        --bottomHealthCount;
                        --emptyHealthCount;
                        continue;
                    }
                    hearts.add(Heart.half(healthPieces[1], false));
                    --bottomHealthCount;
                    continue;
                }
                if (emptyHealthCount > 0) {
                    if (emptyHealthCount > 1) {
                        hearts.add(CONTAINER_FULL);
                        emptyHealthCount -= 2;
                        continue;
                    }
                    hearts.add(CONTAINER_HALF);
                    --emptyHealthCount;
                    continue;
                }
                if (topAbsorptionCount > 0) {
                    if (topAbsorptionCount > 1) {
                        hearts.add(Heart.full(absorptionPieces[0]));
                        topAbsorptionCount -= 2;
                        continue;
                    }
                    hearts.add(Heart.full(absorptionPieces[0], absorptionPieces[1]));
                    --topAbsorptionCount;
                    --bottomAbsorptionCount;
                    continue;
                }
                if (bottomAbsorptionCount <= 0) continue;
                if (bottomAbsorptionCount > 1) {
                    hearts.add(Heart.full(absorptionPieces[1]));
                    bottomAbsorptionCount -= 2;
                    continue;
                }
                hearts.add(Heart.half(absorptionPieces[1], false));
                --bottomAbsorptionCount;
            }
        }
        return (Heart[])hearts.toArray(Heart[]::new);
    }
}

