/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.core.entity.Knife;
import cofh.lib.item.SwordItemCoFH;
import cofh.lib.util.Constants;
import cofh.lib.util.helpers.MathHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;

public class KnifeItem
extends SwordItemCoFH {
    private static final int DEFAULT_ATTACK_DAMAGE = 1;
    private static final float DEFAULT_ATTACK_SPEED = -2.0f;
    protected Supplier<CreativeModeTab> displayGroup;
    protected Supplier<Boolean> showInGroups = Constants.TRUE;
    protected String modId = "";
    private static final AbstractProjectileDispenseBehavior DISPENSER_BEHAVIOR = new AbstractProjectileDispenseBehavior(){

        public Projectile m_6895_(Level worldIn, Position position, ItemStack stackIn) {
            Knife knife = new Knife(worldIn, position.m_7096_(), position.m_7098_(), position.m_7094_(), stackIn);
            knife.f_36705_ = AbstractArrow.Pickup.ALLOWED;
            return knife;
        }

        protected float m_7101_() {
            return 3.0f;
        }
    };

    public KnifeItem(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSER_BEHAVIOR);
    }

    public KnifeItem(Tier tier, Item.Properties builder) {
        this(tier, 1, -2.0f, builder);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || enchantment.equals(Enchantments.f_44955_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity living, int durationRemaining) {
        if (living instanceof Player) {
            Player player = (Player)living;
            float power = BowItem.m_40661_((int)(this.m_8105_(stack) - durationRemaining));
            if ((double)power < 0.1) {
                return;
            }
            if (!world.f_46443_) {
                Knife knife = new Knife(world, (LivingEntity)player, stack);
                knife.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, power * 3.0f, 0.1f);
                if (player.m_150110_().f_35937_) {
                    knife.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                world.m_7967_((Entity)knife);
            }
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f / (MathHelper.RANDOM.m_188501_() * 0.4f + 1.2f) + power * 0.5f);
            if (!player.m_150110_().f_35937_) {
                player.m_150109_().m_36057_(stack);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    @Override
    public KnifeItem setDisplayGroup(Supplier<CreativeModeTab> displayGroup) {
        this.displayGroup = displayGroup;
        return this;
    }

    @Override
    public KnifeItem setModId(String modId) {
        this.modId = modId;
        return this;
    }

    @Override
    public KnifeItem setShowInGroups(Supplier<Boolean> showInGroups) {
        this.showInGroups = showInGroups;
        return this;
    }

    @Override
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.showInGroups.get().booleanValue() || this.displayGroup != null && this.displayGroup.get() != null && this.displayGroup.get() != group) {
            return;
        }
        super.m_6787_(group, items);
    }

    @Override
    public Collection<CreativeModeTab> getCreativeTabs() {
        return this.displayGroup != null && this.displayGroup.get() != null ? Collections.singletonList(this.displayGroup.get()) : super.getCreativeTabs();
    }

    @Override
    public String getCreatorModId(ItemStack itemStack) {
        return this.modId == null || this.modId.isEmpty() ? super.getCreatorModId(itemStack) : this.modId;
    }
}

