/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.entity;

import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.init.CoreEntities;
import cofh.core.init.CoreMobEffects;
import cofh.core.init.CoreParticles;
import cofh.core.util.AreaUtils;
import cofh.core.util.helpers.ArcheryHelper;
import cofh.lib.entity.AbstractAoESpell;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;

public class ElectricField
extends AbstractAoESpell
implements IEntityAdditionalSpawnData {
    protected float power;
    protected int lastArc = 0;

    public ElectricField(EntityType<? extends ElectricField> type, Level level) {
        super((EntityType<? extends AbstractAoESpell>)type, level);
    }

    public ElectricField(Level level, LivingEntity owner, Vec3 pos, float radius, int duration, float power) {
        this((EntityType<? extends ElectricField>)((EntityType)CoreEntities.ELECTRIC_FIELD.get()), level);
        this.m_20219_(pos);
        this.owner = owner;
        this.radius = radius;
        this.duration = duration;
        this.power = power;
        this.m_20011_(this.m_20191_().m_82400_((double)radius));
    }

    public ElectricField(Level level, Vec3 pos, float radius, int duration) {
        this(level, null, pos, radius, duration, 1.0f);
    }

    @Override
    public void activeTick() {
        if (!this.f_19853_.m_5776_()) {
            int max = 16;
            if (this.f_19797_ < this.duration + 10 && (this.lastArc >= max || this.f_19796_.m_188503_(max - this.lastArc) == 0)) {
                this.lastArc = 0;
                this.summonArc();
            } else {
                ++this.lastArc;
            }
        }
    }

    protected void summonArc() {
        Vec3 pos = this.m_20182_();
        Predicate<Entity> filter = EntitySelector.f_20403_;
        if (this.owner != null) {
            filter = filter.and(entity -> !entity.m_20365_((Entity)this.owner));
        }
        List<Entity> entities = AreaUtils.getEntitiesInSphere(this.f_19853_, pos, this.radius, this, filter);
        Vec3 end = this.f_19796_.m_188503_(5) < entities.size() ? entities.get(this.f_19796_.m_188503_(entities.size())).m_20191_().m_82399_() : new Vec3(this.f_19796_.m_188583_(), -Math.abs(this.f_19796_.m_188583_()), this.f_19796_.m_188583_()).m_82541_().m_82490_((double)this.radius).m_82549_(pos);
        pos = pos.m_82520_(0.0, (double)(this.radius - 0.5f), 0.0);
        BlockHitResult raytrace = this.f_19853_.m_45547_(new ClipContext(pos, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        end = raytrace.m_82450_();
        ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BiColorParticleOptions((ParticleType<? extends BiColorParticleOptions>)((ParticleType)CoreParticles.STRAIGHT_ARC.get()), 0.2f, 4.0f, 0.0f, -1, -240988), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, end.f_82479_, end.f_82480_, end.f_82481_, 1.0);
        float padding = 0.1f;
        ArcheryHelper.findHitEntities(entities.stream(), pos, end, new Vec3((double)padding, (double)padding, (double)padding)).forEach(result -> {
            Entity target = result.m_82443_();
            target.m_6469_(DamageSource.f_19306_, this.power * 4.0f);
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                if (this.f_19796_.m_188501_() < this.power * 0.4f) {
                    living.m_7292_(new MobEffectInstance((MobEffect)CoreMobEffects.SHOCKED.get(), 80, 0, true, false, true));
                }
            }
        });
    }

    public float getRadius() {
        return this.radius;
    }

    public int getTextureIndex(int max) {
        if (this.f_19797_ < 3 || this.duration - this.f_19797_ < 3) {
            return 0;
        }
        return this.f_19796_.m_188503_(max - 1) + 1;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.duration);
        buffer.writeFloat(this.radius);
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.duration = additionalData.readInt();
        this.radius = additionalData.readFloat();
        this.m_20011_(this.m_20191_().m_82400_((double)this.radius));
    }
}

