/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.PointToPointParticle;
import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.vfx.Color;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec2;

public class ShardParticle
extends PointToPointParticle {
    protected Vector3f disp;

    private ShardParticle(BiColorParticleOptions data, ClientLevel level, double sx, double sy, double sz, double ex, double ey, double ez) {
        super(data, level, sx, sy, sz, ex, ey, ez);
        this.f_172258_ = 1.0f;
        this.disp = new Vector3f((float)(ex - sx), (float)(ey - sy), (float)(ez - sz));
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLight, float time, float pTicks) {
        float progress = 1.0f - MathHelper.cos(time / this.duration * (float)Math.PI * 0.5f);
        float dx = this.disp.m_122239_() * progress;
        float dy = this.disp.m_122260_() * progress;
        float dz = this.disp.m_122269_() * progress;
        stack.m_85837_((double)dx, (double)dy, (double)dz);
        float dist = MathHelper.dist(dx, dy, dz);
        stack.m_85841_(this.size, this.size, this.size);
        VFXHelper.alignVertical(stack, this.disp);
        PoseStack.Pose last = stack.m_85850_();
        Matrix4f pose = last.m_85861_();
        Matrix3f norm = last.m_85864_();
        Vector4f start = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        start.m_123607_(pose);
        Vector4f end = new Vector4f(0.0f, -Math.min(dist / this.size, 3.0f), 0.0f, 1.0f);
        end.m_123607_(pose);
        Vec2 perp = VFXHelper.axialPerp(start, end, 1.0f);
        float w = 0.12f * this.size;
        float xs = perp.f_82470_ * w;
        float ys = perp.f_82471_ * w;
        consumer = buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT);
        new VFXHelper.VFXNode(start.m_123601_() + xs, start.m_123601_() - xs, start.m_123615_() + ys, start.m_123615_() - ys, start.m_123616_(), w).renderStart(norm, consumer, packedLight, this.c1);
        new VFXHelper.VFXNode(end.m_123601_(), end.m_123601_(), end.m_123615_(), end.m_123615_(), end.m_123616_(), w * 0.1f).renderEnd(norm, consumer, packedLight, this.c1);
        if (!this.c0.sameRGB(this.c1)) {
            buffer.m_6299_(RenderTypes.LINEAR_GLOW);
            buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT);
        }
        RenderHelper.renderBipyramid(stack, consumer, packedLight, this.c0, 4, 0.6f, 0.1f);
        buffer.m_6299_(RenderTypes.LINEAR_GLOW);
        buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT);
        RenderHelper.renderBipyramid(stack, consumer, packedLight, this.c0.mix(Color.WHITE, 0.5f), 4, 0.4f, 0.066f);
    }

    @Nonnull
    public static ParticleProvider<BiColorParticleOptions> factory(SpriteSet spriteSet) {
        return ShardParticle::new;
    }
}

