/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt.lib;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.ErrorFactory;
import cc.tweaked.internal.cobalt.LuaError;
import cc.tweaked.internal.cobalt.LuaState;
import cc.tweaked.internal.cobalt.LuaString;
import cc.tweaked.internal.cobalt.LuaTable;
import cc.tweaked.internal.cobalt.LuaThread;
import cc.tweaked.internal.cobalt.LuaUserdata;
import cc.tweaked.internal.cobalt.LuaValue;
import cc.tweaked.internal.cobalt.Prototype;
import cc.tweaked.internal.cobalt.ValueFactory;
import cc.tweaked.internal.cobalt.Varargs;
import cc.tweaked.internal.cobalt.debug.DebugFrame;
import cc.tweaked.internal.cobalt.debug.DebugHelpers;
import cc.tweaked.internal.cobalt.debug.DebugState;
import cc.tweaked.internal.cobalt.function.LocalVariable;
import cc.tweaked.internal.cobalt.function.LuaClosure;
import cc.tweaked.internal.cobalt.function.LuaFunction;
import cc.tweaked.internal.cobalt.function.RegisteredFunction;
import cc.tweaked.internal.cobalt.function.VarArgFunction;
import cc.tweaked.internal.cobalt.lib.LuaLibrary;

public class DebugLib
implements LuaLibrary {
    private static final LuaString MAIN = ValueFactory.valueOf("main");
    private static final LuaString LUA = ValueFactory.valueOf("Lua");
    private static final LuaString C = ValueFactory.valueOf("C");
    private static final LuaString C_SOURCE = ValueFactory.valueOf("[C]");
    public static final LuaString QMARK = ValueFactory.valueOf("?");
    private static final LuaString EXTERNAL_HOOK = ValueFactory.valueOf("external hook");
    private static final LuaString FUNC = ValueFactory.valueOf("func");
    private static final LuaString NUPS = ValueFactory.valueOf("nups");
    private static final LuaString NAME = ValueFactory.valueOf("name");
    private static final LuaString NAMEWHAT = ValueFactory.valueOf("namewhat");
    private static final LuaString WHAT = ValueFactory.valueOf("what");
    private static final LuaString SOURCE = ValueFactory.valueOf("source");
    private static final LuaString SHORT_SRC = ValueFactory.valueOf("short_src");
    private static final LuaString LINEDEFINED = ValueFactory.valueOf("linedefined");
    private static final LuaString LASTLINEDEFINED = ValueFactory.valueOf("lastlinedefined");
    private static final LuaString CURRENTLINE = ValueFactory.valueOf("currentline");
    private static final LuaString CURRENTCOLUMN = ValueFactory.valueOf("currentcolumn");
    private static final LuaString ACTIVELINES = ValueFactory.valueOf("activelines");
    private static final LuaString NPARAMS = ValueFactory.valueOf("nparams");
    private static final LuaString ISVARARG = ValueFactory.valueOf("isvararg");
    private static final LuaString ISTAILCALL = ValueFactory.valueOf("istailcall");
    private final LuaTable registry = new LuaTable();

    @Override
    public LuaTable add(LuaState state, LuaTable env) {
        LuaTable t = new LuaTable();
        RegisteredFunction.bind(env, t, new RegisteredFunction[]{RegisteredFunction.ofV("debug", DebugLib::debug), RegisteredFunction.ofV("getfenv", DebugLib::getfenv), RegisteredFunction.ofV("gethook", DebugLib::gethook), RegisteredFunction.of("getinfo", new VarArgFunction(){

            @Override
            public Varargs invoke(LuaState state, Varargs args) throws LuaError {
                return DebugLib.getinfo(state, args, this);
            }
        }), RegisteredFunction.ofV("getlocal", DebugLib::getlocal), RegisteredFunction.ofV("getmetatable", DebugLib::getmetatable), RegisteredFunction.ofV("getregistry", this::getregistry), RegisteredFunction.ofV("getupvalue", DebugLib::getupvalue), RegisteredFunction.ofV("setfenv", DebugLib::setfenvImpl), RegisteredFunction.ofV("sethook", DebugLib::sethook), RegisteredFunction.ofV("setlocal", DebugLib::setlocal), RegisteredFunction.ofV("setmetatable", DebugLib::setmetatable), RegisteredFunction.ofV("setupvalue", DebugLib::varargs), RegisteredFunction.ofV("traceback", DebugLib::traceback), RegisteredFunction.ofV("upvalueid", DebugLib::upvalueId), RegisteredFunction.ofV("upvaluejoin", DebugLib::upvalueJoin)});
        env.rawset("debug", (LuaValue)t);
        state.loadedPackages.rawset("debug", (LuaValue)t);
        return t;
    }

    private static Varargs debug(LuaState state, Varargs args) {
        return Constants.NONE;
    }

    private static Varargs gethook(LuaState state, Varargs args) throws LuaError {
        int a = 1;
        LuaThread thread = args.arg(a).isThread() ? args.arg(a++).checkThread() : state.getCurrentThread();
        DebugState ds = thread.getDebugState();
        LuaValue hook = ds.hookfunc == null ? Constants.NIL : (ds.hookfunc instanceof LuaValue ? (LuaValue)((Object)ds.hookfunc) : EXTERNAL_HOOK);
        return ValueFactory.varargsOf(hook, (LuaValue)ValueFactory.valueOf((ds.hookcall ? "c" : "") + (ds.hookrtrn ? "r" : "") + (ds.hookline ? "l" : "")), (Varargs)ValueFactory.valueOf(ds.hookcount));
    }

    private static Varargs sethook(LuaState state, Varargs args) throws LuaError {
        int a = 1;
        LuaThread thread = args.arg(a).isThread() ? args.arg(a++).checkThread() : state.getCurrentThread();
        int i1 = a++;
        LuaFunction func = args.arg(i1).optFunction(null);
        int i3 = a++;
        String str = args.arg(i3).optString("");
        int i2 = a++;
        int count = args.arg(i2).optInteger(0);
        boolean call = false;
        boolean line = false;
        boolean rtrn = false;
        if (func != null) {
            block5: for (int i = 0; i < str.length(); ++i) {
                switch (str.charAt(i)) {
                    case 'c': {
                        call = true;
                        continue block5;
                    }
                    case 'l': {
                        line = true;
                        continue block5;
                    }
                    case 'r': {
                        rtrn = true;
                    }
                }
            }
        } else {
            count = 0;
        }
        thread.getDebugState().setHook(func, call, line, rtrn, count);
        return Constants.NONE;
    }

    private static Varargs getfenv(LuaState state, Varargs args) throws LuaError {
        LuaValue object = args.first();
        LuaTable env = object.getfenv();
        return env != null ? env : Constants.NIL;
    }

    private static Varargs setfenvImpl(LuaState state, Varargs args) throws LuaError {
        LuaValue object = args.first();
        LuaTable table = args.arg(2).checkTable();
        object.setfenv(table);
        return object;
    }

    protected static Varargs getinfo(LuaState state, Varargs args, LuaValue level0func) throws LuaError {
        Object di;
        int arg = 1;
        LuaThread thread = args.arg(arg).isThread() ? args.arg(arg++).checkThread() : state.getCurrentThread();
        LuaValue func = args.arg(arg);
        String what = args.arg(arg + 1).optString("flnStu");
        DebugState ds = thread.getDebugState();
        if (func.isNumber()) {
            int level = func.checkInteger();
            di = thread != state.getCurrentThread() ? ds.getFrame(level) : (level < 0 ? null : (level == 0 ? new DebugFrame(level0func.checkFunction()) : ds.getFrame(level - 1)));
        } else {
            di = ds.findDebugInfo(func.checkFunction());
        }
        if (di == null) {
            return Constants.NIL;
        }
        LuaTable info = new LuaTable();
        LuaClosure c = ((DebugFrame)di).closure;
        int j = what.length();
        block9: for (int i = 0; i < j; ++i) {
            switch (what.charAt(i)) {
                case 'S': {
                    Prototype p;
                    if (c != null) {
                        p = c.getPrototype();
                        info.rawset(WHAT, (LuaValue)(p.lineDefined == 0 ? MAIN : LUA));
                        info.rawset(SOURCE, (LuaValue)p.source);
                        info.rawset(SHORT_SRC, (LuaValue)p.sourceShort());
                        info.rawset(LINEDEFINED, (LuaValue)ValueFactory.valueOf(p.lineDefined));
                        info.rawset(LASTLINEDEFINED, (LuaValue)ValueFactory.valueOf(p.lastLineDefined));
                        continue block9;
                    }
                    String shortName = ((DebugFrame)di).func == null ? "nil" : ((DebugFrame)di).func.debugName();
                    LuaString name = ValueFactory.valueOf("[C] " + shortName);
                    info.rawset(WHAT, (LuaValue)C);
                    info.rawset(SOURCE, (LuaValue)name);
                    info.rawset(SHORT_SRC, (LuaValue)C_SOURCE);
                    info.rawset(LINEDEFINED, (LuaValue)Constants.MINUSONE);
                    info.rawset(LASTLINEDEFINED, (LuaValue)Constants.MINUSONE);
                    continue block9;
                }
                case 'l': {
                    if (c == null) continue block9;
                    Prototype p = c.getPrototype();
                    int line = p.lineInfo == null || ((DebugFrame)di).pc < 0 || ((DebugFrame)di).pc >= p.lineInfo.length ? -1 : p.lineInfo[((DebugFrame)di).pc];
                    int column = p.columnInfo == null || ((DebugFrame)di).pc < 0 || ((DebugFrame)di).pc >= p.columnInfo.length ? -1 : p.columnInfo[((DebugFrame)di).pc];
                    info.rawset(CURRENTLINE, (LuaValue)ValueFactory.valueOf(line));
                    if (column <= 0) continue block9;
                    info.rawset(CURRENTCOLUMN, (LuaValue)ValueFactory.valueOf(column));
                    continue block9;
                }
                case 'u': {
                    info.rawset(NUPS, (LuaValue)ValueFactory.valueOf(c != null ? c.getPrototype().upvalues : 0));
                    info.rawset(NPARAMS, (LuaValue)ValueFactory.valueOf(c != null ? c.getPrototype().parameters : 0));
                    info.rawset(ISVARARG, (LuaValue)ValueFactory.valueOf(c == null || c.getPrototype().isVarArg > 0));
                    continue block9;
                }
                case 'n': {
                    LuaString[] kind = ((DebugFrame)di).getFuncKind();
                    info.rawset(NAME, kind != null ? kind[0] : Constants.NIL);
                    info.rawset(NAMEWHAT, (LuaValue)(kind != null ? kind[1] : Constants.EMPTYSTRING));
                    continue block9;
                }
                case 'f': {
                    info.rawset(FUNC, ((DebugFrame)di).func == null ? Constants.NIL : ((DebugFrame)di).func);
                    continue block9;
                }
                case 'L': {
                    if (((DebugFrame)di).closure == null) continue block9;
                    LuaTable lines = new LuaTable();
                    info.rawset(ACTIVELINES, (LuaValue)lines);
                    int[] lineinfo = ((DebugFrame)di).closure.getPrototype().lineInfo;
                    if (lineinfo == null) continue block9;
                    for (int line : lineinfo) {
                        lines.rawset(line, (LuaValue)Constants.TRUE);
                    }
                    continue block9;
                }
                case 't': {
                    info.rawset(ISTAILCALL, (LuaValue)ValueFactory.valueOf((((DebugFrame)di).flags & 0x2000) != 0));
                    continue block9;
                }
                default: {
                    throw ErrorFactory.argError(arg + 1, "invalid option");
                }
            }
        }
        return info;
    }

    private static Varargs getlocal(LuaState state, Varargs args) throws LuaError {
        DebugState ds;
        DebugFrame di;
        int arg = 1;
        LuaThread thread = args.arg(arg).isThread() ? args.arg(arg++).checkThread() : state.getCurrentThread();
        int local = args.arg(arg + 1).checkInteger();
        if (args.arg(arg).isFunction()) {
            LuaFunction function = args.arg(arg).checkFunction();
            if (!function.isClosure()) {
                return Constants.NIL;
            }
            Prototype proto = function.checkClosure().getPrototype();
            LocalVariable[] variables = proto.locals;
            return variables != null && local > 0 && local <= variables.length && local <= proto.parameters ? variables[local - 1].name : Constants.NIL;
        }
        int level = args.arg(arg).checkInteger();
        if (thread == state.getCurrentThread()) {
            --level;
        }
        if ((di = (ds = thread.getDebugState()).getFrame(level)) == null) {
            throw new LuaError("bad argument #" + arg + " (level out of range)");
        }
        LuaString name = di.getLocalName(local);
        if (name == null || di.stack == null) {
            return Constants.NIL;
        }
        LuaValue value = di.stack[local - 1];
        return ValueFactory.varargsOf((LuaValue)name, (Varargs)value);
    }

    private static Varargs setlocal(LuaState state, Varargs args) throws LuaError {
        DebugFrame di;
        int arg = 1;
        LuaThread thread = args.arg(arg).isThread() ? args.arg(arg++).checkThread() : state.getCurrentThread();
        int level = args.arg(arg).checkInteger();
        int local = args.arg(arg + 1).checkInteger();
        LuaValue value = args.arg(arg + 2);
        DebugState ds = thread.getDebugState();
        if (thread == state.getCurrentThread()) {
            --level;
        }
        if ((di = ds.getFrame(level)) == null) {
            throw new LuaError("bad argument #" + arg + " (level out of range)");
        }
        LuaString name = di.getLocalName(local);
        if (name == null || di.stack == null) {
            return Constants.NIL;
        }
        di.stack[local - 1] = value;
        return name;
    }

    private static Varargs getmetatable(LuaState state, Varargs args) {
        LuaValue object = args.arg(1);
        LuaTable mt = object.getMetatable(state);
        return mt != null ? mt : Constants.NIL;
    }

    private static Varargs setmetatable(LuaState state, Varargs args) {
        LuaValue object = args.arg(1);
        try {
            LuaTable mt = args.arg(2).optTable(null);
            switch (object.type()) {
                case 0: {
                    state.nilMetatable = mt;
                    break;
                }
                case 3: {
                    state.numberMetatable = mt;
                    break;
                }
                case 1: {
                    state.booleanMetatable = mt;
                    break;
                }
                case 4: {
                    state.stringMetatable = mt;
                    break;
                }
                case 6: {
                    state.functionMetatable = mt;
                    break;
                }
                case 8: {
                    state.threadMetatable = mt;
                    break;
                }
                default: {
                    object.setMetatable(state, mt);
                }
            }
            return Constants.TRUE;
        }
        catch (LuaError e) {
            return ValueFactory.varargsOf((LuaValue)Constants.FALSE, (Varargs)ValueFactory.valueOf(e.toString()));
        }
    }

    private Varargs getregistry(LuaState state, Varargs args) {
        return this.registry;
    }

    private static LuaString findupvalue(LuaClosure c, int up) {
        Prototype p = c.getPrototype();
        if (up > 0 && p.upvalueNames != null && up <= p.upvalueNames.length) {
            return p.upvalueNames[up - 1];
        }
        return null;
    }

    private static Varargs getupvalue(LuaState state, Varargs args) throws LuaError {
        LuaClosure c;
        LuaString name;
        LuaFunction func = args.arg(1).checkFunction();
        int up = args.arg(2).checkInteger();
        if (func instanceof LuaClosure && (name = DebugLib.findupvalue(c = (LuaClosure)func, up)) != null) {
            return ValueFactory.varargsOf((LuaValue)name, (Varargs)c.getUpvalue(up - 1).getValue());
        }
        return Constants.NIL;
    }

    private static Varargs varargs(LuaState state, Varargs args) throws LuaError {
        LuaClosure c;
        LuaString name;
        LuaFunction func = args.arg(1).checkFunction();
        int up = args.arg(2).checkInteger();
        LuaValue value = args.arg(3);
        if (func instanceof LuaClosure && (name = DebugLib.findupvalue(c = (LuaClosure)func, up)) != null) {
            c.getUpvalue(up - 1).setValue(value);
            return name;
        }
        return Constants.NIL;
    }

    private static Varargs traceback(LuaState state, Varargs args) throws LuaError {
        LuaValue messageValue;
        int a = 1;
        LuaThread thread = args.arg(a).isThread() ? args.arg(a++).checkThread() : state.getCurrentThread();
        if ((messageValue = args.arg(a++)) != Constants.NIL && !messageValue.isString()) {
            return messageValue;
        }
        String message = messageValue.optString(null);
        int level = thread == state.getCurrentThread() ? args.arg(a).optInteger(1) - 1 : args.arg(a).optInteger(0);
        StringBuilder sb = new StringBuilder();
        if (message != null) {
            sb.append(message).append('\n');
        }
        return ValueFactory.valueOf(DebugHelpers.traceback(sb, thread, level).toString());
    }

    private static LuaClosure getClosureForUpvalue(Varargs args, int offset, int upvalue) throws LuaError {
        LuaFunction function = args.arg(offset).checkFunction();
        if (function instanceof LuaClosure) {
            LuaClosure closure = (LuaClosure)function;
            if (upvalue >= 0 && upvalue < closure.getPrototype().upvalues) {
                return closure;
            }
        }
        throw ErrorFactory.argError(offset, "invalid upvalue index");
    }

    private static Varargs upvalueId(LuaState state, Varargs args) throws LuaError {
        int upvalue = args.arg(2).checkInteger() - 1;
        LuaClosure closure = DebugLib.getClosureForUpvalue(args, 1, upvalue);
        return new LuaUserdata(closure.getUpvalue(upvalue));
    }

    private static Varargs upvalueJoin(LuaState state, Varargs args) throws LuaError {
        int upvalue1 = args.arg(2).checkInteger() - 1;
        LuaClosure closure1 = DebugLib.getClosureForUpvalue(args, 1, upvalue1);
        int upvalue2 = args.arg(4).checkInteger() - 1;
        LuaClosure closure2 = DebugLib.getClosureForUpvalue(args, 3, upvalue2);
        closure1.setUpvalue(upvalue1, closure2.getUpvalue(upvalue2));
        return Constants.NONE;
    }
}

