/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.building.tilesupport;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class NBTTileEntityData
implements ITileEntityData {
    @Nonnull
    private final CompoundTag nbt;
    @Nullable
    private final MaterialList requiredMaterials;

    public static NBTTileEntityData ofTile(BlockEntity te) {
        CompoundTag nbt = te.m_187482_();
        return new NBTTileEntityData(nbt);
    }

    public NBTTileEntityData(CompoundTag nbt, @Nullable MaterialList requiredMaterials) {
        this.nbt = Objects.requireNonNull(nbt);
        this.requiredMaterials = requiredMaterials;
    }

    public NBTTileEntityData(CompoundTag nbt) {
        this(nbt, null);
    }

    @Override
    public ITileDataSerializer getSerializer() {
        return (ITileDataSerializer)Registries.NBT_TILE_DATA_SERIALIZER.get();
    }

    @Override
    public MaterialList getRequiredItems(BuildContext context, BlockState state, @Nullable HitResult target, @Nullable BlockPos pos) {
        if (this.requiredMaterials != null) {
            return this.requiredMaterials;
        }
        return ITileEntityData.super.getRequiredItems(context, state, target, pos);
    }

    @Override
    public boolean placeIn(BuildContext context, BlockState state, BlockPos position) {
        BuildingGadgets.LOG.trace("Placing {} with Tile NBT at {}.", (Object)state, (Object)position);
        context.getWorld().m_7731_(position, state, 0);
        BlockEntity te = context.getWorld().m_7702_(position);
        if (te != null) {
            try {
                te.deserializeNBT(this.getNBTModifiable());
            }
            catch (Exception e) {
                BuildingGadgets.LOG.debug("Failed to apply Tile NBT Data to {} at {} in Context {}", (Object)state, (Object)position, (Object)context, (Object)e);
            }
        }
        return true;
    }

    public CompoundTag getNBT() {
        return this.nbt.m_6426_();
    }

    @Nullable
    public MaterialList getRequiredMaterials() {
        return this.requiredMaterials;
    }

    protected CompoundTag getNBTModifiable() {
        return this.nbt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NBTTileEntityData)) {
            return false;
        }
        NBTTileEntityData that = (NBTTileEntityData)o;
        if (!this.nbt.equals((Object)that.nbt)) {
            return false;
        }
        return this.getRequiredMaterials() != null ? this.getRequiredMaterials().equals(that.getRequiredMaterials()) : that.getRequiredMaterials() == null;
    }

    public int hashCode() {
        int result = this.nbt.hashCode();
        result = 31 * result + (this.getRequiredMaterials() != null ? this.getRequiredMaterials().hashCode() : 0);
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nbt", (Object)this.nbt).add("requiredMaterials", (Object)this.requiredMaterials).toString();
    }
}

