/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network.packets;

import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketCopyCoords {
    private final BlockPos start;
    private final BlockPos end;

    public PacketCopyCoords(BlockPos start, BlockPos end) {
        this.start = start;
        this.end = end;
    }

    public static void encode(PacketCopyCoords msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.start);
        buffer.m_130064_(msg.end);
    }

    public static PacketCopyCoords decode(FriendlyByteBuf buffer) {
        return new PacketCopyCoords(buffer.m_130135_(), buffer.m_130135_());
    }

    public static class Handler {
        public static void handle(PacketCopyCoords msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer playerEntity = ctx.get().getSender();
            if (playerEntity == null) {
                return;
            }
            ctx.get().enqueueWork(() -> {
                ItemStack heldItem = GadgetCopyPaste.getGadget((Player)playerEntity);
                if (heldItem.m_41619_()) {
                    return;
                }
                BlockPos startPos = msg.start;
                BlockPos endPos = msg.end;
                if (startPos.equals((Object)BlockPos.f_121853_) && endPos.equals((Object)BlockPos.f_121853_)) {
                    GadgetCopyPaste.setSelectedRegion(heldItem, null);
                    playerEntity.m_5661_((Component)MessageTranslation.AREA_RESET.componentTranslation(new Object[0]).m_6270_(Styles.AQUA), true);
                } else {
                    GadgetCopyPaste.setSelectedRegion(heldItem, new Region((Vec3i)startPos, (Vec3i)endPos));
                }
                Optional<Region> regionOpt = GadgetCopyPaste.getSelectedRegion(heldItem);
                if (!regionOpt.isPresent()) {
                    playerEntity.m_5661_((Component)MessageTranslation.FIRST_COPY.componentTranslation(new Object[0]).m_6270_(Styles.DK_GREEN), true);
                }
                regionOpt.ifPresent(region -> ((GadgetCopyPaste)heldItem.m_41720_()).tryCopy(heldItem, playerEntity.f_19853_, (Player)playerEntity, (Region)region));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

