/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.registry.fluid;

import earth.terrarium.botarium.api.registry.fluid.FluidData;
import earth.terrarium.botarium.api.registry.fluid.FluidProperties;
import earth.terrarium.botarium.forge.regsitry.fluid.BotariumFluidType;
import earth.terrarium.botarium.forge.regsitry.fluid.ForgeFluidData;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class FluidRegistry {
    private final DeferredRegister<FluidType> registry;
    private final String modid;

    public FluidRegistry(String modid) {
        this.registry = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)modid);
        this.modid = modid;
    }

    public FluidData register(FluidProperties properties) {
        RegistryObject type = this.registry.register(properties.id().m_135815_(), () -> BotariumFluidType.of(properties));
        return new ForgeFluidData((Supplier<BotariumFluidType>)type, properties);
    }

    public FluidData register(String id, FluidProperties.Builder properties) {
        return this.register(properties.build(new ResourceLocation(this.modid, id)));
    }

    public void initialize() {
        this.registry.register(FMLJavaModLoadingContext.get().getModEventBus());
    }
}

