/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesSurfaceRules;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class SkiesSurfaceRuleData {
    private static final SurfaceRules.RuleSource BEDROCK = SkiesSurfaceRuleData.stateRule(Blocks.f_50752_);
    private static final SurfaceRules.RuleSource TURQUOISE_GRASS = SkiesSurfaceRuleData.stateRule(SkiesBlocks.turquoise_grass_block);
    private static final SurfaceRules.RuleSource TURQUOISE_DIRT = SkiesSurfaceRuleData.stateRule(SkiesBlocks.turquoise_dirt);
    private static final SurfaceRules.RuleSource TURQUOISE_COARSE_DIRT = SkiesSurfaceRuleData.stateRule(SkiesBlocks.coarse_turquoise_dirt);
    private static final SurfaceRules.RuleSource MIDNIGHT_SAND = SkiesSurfaceRuleData.stateRule(SkiesBlocks.midnight_sand);
    private static final SurfaceRules.RuleSource MIDNIGHT_SANDSTONE = SkiesSurfaceRuleData.stateRule(SkiesBlocks.midnight_sandstone);
    private static final SurfaceRules.RuleSource LUNAR_GRASS = SkiesSurfaceRuleData.stateRule(SkiesBlocks.lunar_grass_block);
    private static final SurfaceRules.RuleSource LUNAR_DIRT = SkiesSurfaceRuleData.stateRule(SkiesBlocks.lunar_dirt);
    private static final SurfaceRules.RuleSource LUNAR_COARSE_DIRT = SkiesSurfaceRuleData.stateRule(SkiesBlocks.coarse_lunar_dirt);
    private static final SurfaceRules.RuleSource CRYSTAL_SAND = SkiesSurfaceRuleData.stateRule(SkiesBlocks.crystal_sand);
    private static final SurfaceRules.RuleSource CRYSTAL_SANDSTONE = SkiesSurfaceRuleData.stateRule(SkiesBlocks.crystal_sandstone);

    public static SurfaceRules.RuleSource everbright(boolean preliminarySurface, boolean bedrockRoof, boolean bedrockFloor) {
        SurfaceRules.ConditionSource aboveWater = SurfaceRules.m_189382_((int)-1, (int)0);
        SurfaceRules.RuleSource sandSource = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)MIDNIGHT_SANDSTONE), MIDNIGHT_SAND});
        SurfaceRules.ConditionSource isOcean = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{SkiesBiomes.MIDDAY_SHORE.getKey(), SkiesBiomes.PEEKING_OCEAN.getKey(), SkiesBiomes.DEEP_PEEKING_OCEAN.getKey(), SkiesBiomes.BRUMBLE_FOREST.getKey()});
        SurfaceRules.RuleSource coarseMixSource = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)aboveWater, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{SkiesBiomes.SLUSHLANDS.getKey(), SkiesBiomes.POLAR_HIGHLAND.getKey()}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189412_((ResourceKey)Noises.f_189256_, (double)-0.23636363636363636, (double)0.11515151515151514), (SurfaceRules.RuleSource)TURQUOISE_COARSE_DIRT)))});
        SurfaceRules.RuleSource belowSurfaceSource = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SkiesSurfaceRuleData.isLowForMidnightSand(MIDNIGHT_SANDSTONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{SkiesBiomes.MIDDAY_SHORE.getKey()}), (SurfaceRules.RuleSource)SkiesSurfaceRuleData.upwardGradient("midnight_sandstone_gradient", MIDNIGHT_SANDSTONE, 70)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isOcean, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)aboveWater), (SurfaceRules.RuleSource)MIDNIGHT_SANDSTONE)), TURQUOISE_DIRT});
        SurfaceRules.RuleSource onSurfaceSource = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SkiesSurfaceRuleData.isLowForMidnightSand(MIDNIGHT_SAND), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{SkiesBiomes.MIDDAY_SHORE.getKey()}), (SurfaceRules.RuleSource)SkiesSurfaceRuleData.upwardGradient("midnight_sand_gradient", MIDNIGHT_SAND, 70)), coarseMixSource, SurfaceRules.m_189394_((SurfaceRules.ConditionSource)aboveWater, (SurfaceRules.RuleSource)TURQUOISE_GRASS), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)isOcean, (SurfaceRules.RuleSource)sandSource), belowSurfaceSource});
        SurfaceRules.RuleSource floorModifiers = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)onSurfaceSource), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)belowSurfaceSource)});
        ImmutableList.Builder builder = ImmutableList.builder();
        if (bedrockRoof) {
            builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_roof", (VerticalAnchor)VerticalAnchor.m_158935_((int)5), (VerticalAnchor)VerticalAnchor.m_158929_())), (SurfaceRules.RuleSource)BEDROCK));
        }
        if (bedrockFloor) {
            builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        }
        builder.add((Object)(preliminarySurface ? SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)floorModifiers) : floorModifiers));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    public static SurfaceRules.RuleSource everdawn(boolean preliminarySurface, boolean bedrockRoof, boolean bedrockFloor) {
        SurfaceRules.ConditionSource aboveWater = SurfaceRules.m_189382_((int)-1, (int)0);
        SurfaceRules.ConditionSource fullySandy = SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{SkiesBiomes.CRYSTAL_DUNES.getKey(), SkiesBiomes.CRYSTAL_DUNES_SPIKES.getKey()});
        SurfaceRules.RuleSource sandSource = SurfaceRules.m_189394_((SurfaceRules.ConditionSource)aboveWater, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)CRYSTAL_SANDSTONE), CRYSTAL_SAND}));
        SurfaceRules.RuleSource crystalRoughsMix = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)aboveWater, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{SkiesBiomes.CRYSTAL_ROUGHS.getKey()}), (SurfaceRules.RuleSource)SkiesSurfaceRules.CrystalRoughness.INSTANCE))});
        SurfaceRules.RuleSource moonlitReservoirMix = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)aboveWater, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{SkiesBiomes.MOONLIT_RESERVOIR.getKey()}), (SurfaceRules.RuleSource)SkiesSurfaceRules.ReservoirMuddiness.INSTANCE))});
        SurfaceRules.RuleSource belowSurfaceSource = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)fullySandy, (SurfaceRules.RuleSource)SkiesSurfaceRuleData.canPlaceCrystalSand(CRYSTAL_SANDSTONE)), LUNAR_DIRT});
        SurfaceRules.RuleSource onSurfaceSource = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{moonlitReservoirMix, crystalRoughsMix, SkiesSurfaceRuleData.isLowForCreekDirt(LUNAR_COARSE_DIRT), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)fullySandy, (SurfaceRules.RuleSource)SkiesSurfaceRuleData.canPlaceCrystalSand(sandSource)), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)aboveWater, (SurfaceRules.RuleSource)LUNAR_GRASS), belowSurfaceSource});
        SurfaceRules.RuleSource floorModifiers = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)onSurfaceSource), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)belowSurfaceSource)});
        ImmutableList.Builder builder = ImmutableList.builder();
        if (bedrockRoof) {
            builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_roof", (VerticalAnchor)VerticalAnchor.m_158935_((int)5), (VerticalAnchor)VerticalAnchor.m_158929_())), (SurfaceRules.RuleSource)BEDROCK));
        }
        if (bedrockFloor) {
            builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        }
        builder.add((Object)(preliminarySurface ? SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189425_(), (SurfaceRules.RuleSource)floorModifiers) : floorModifiers));
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }

    private static SurfaceRules.RuleSource stateRule(Block block) {
        return SkiesSurfaceRuleData.stateRule(block.m_49966_());
    }

    private static SurfaceRules.RuleSource stateRule(BlockState state) {
        return SurfaceRules.m_189390_((BlockState)state);
    }

    private static SurfaceRules.RuleSource isLowForMidnightSand(SurfaceRules.RuleSource rule) {
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{SkiesBiomes.MIDDAY_SHORE.getKey()}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189422_((VerticalAnchor)VerticalAnchor.m_158922_((int)69), (int)0)), (SurfaceRules.RuleSource)rule));
    }

    private static SurfaceRules.RuleSource upwardGradient(String name, SurfaceRules.RuleSource rule, int height) {
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)name, (VerticalAnchor)VerticalAnchor.m_158922_((int)height), (VerticalAnchor)VerticalAnchor.m_158922_((int)(height + 3))), (SurfaceRules.RuleSource)rule);
    }

    private static SurfaceRules.RuleSource canPlaceCrystalSand(SurfaceRules.RuleSource rule) {
        SurfaceRules.ConditionSource aboveWater = SurfaceRules.m_189382_((int)-1, (int)0);
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)aboveWater, (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189422_((VerticalAnchor)VerticalAnchor.m_158922_((int)85), (int)0)), (SurfaceRules.RuleSource)rule));
    }

    private static SurfaceRules.RuleSource isLowForCreekDirt(SurfaceRules.RuleSource rule) {
        return SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189416_((ResourceKey[])new ResourceKey[]{SkiesBiomes.RISING_CREEK.getKey()}), (SurfaceRules.RuleSource)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189392_((SurfaceRules.ConditionSource)SurfaceRules.m_189422_((VerticalAnchor)VerticalAnchor.m_158922_((int)67), (int)0)), (SurfaceRules.RuleSource)rule));
    }
}

