/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.passive;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public class ShadeMonitorModel<T extends LivingEntity>
extends QuadrupedModel<T> {
    protected final ModelPart f_103493_;
    protected final ModelPart bodyBack;
    protected final ModelPart tail;
    protected final ModelPart tailEnd;
    protected final ModelPart f_170854_;
    protected final ModelPart f_170855_;
    protected final ModelPart f_170852_;
    protected final ModelPart f_170853_;
    protected final ModelPart f_103492_;

    public ShadeMonitorModel(ModelPart model) {
        super(model, true, 6.0f, 5.0f, 1.7f, 2.0f, 24);
        this.f_103492_ = model.m_171324_("head");
        this.f_103493_ = model.m_171324_("body");
        this.bodyBack = this.f_103493_.m_171324_("body_back");
        this.tail = this.bodyBack.m_171324_("tail");
        this.tailEnd = this.tail.m_171324_("tail_end");
        this.f_170854_ = model.m_171324_("right_front_leg");
        this.f_170855_ = model.m_171324_("left_front_leg");
        this.f_170852_ = model.m_171324_("right_hind_leg");
        this.f_170853_ = model.m_171324_("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation size) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-3.0f, -2.5f, -6.0f, 6.0f, 5.0f, 6.0f, size), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)-11.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(6, 0).m_171488_(-4.0f, -3.0f, -22.0f, 8.0f, 6.0f, 21.0f, size), PartPose.m_171419_((float)0.0f, (float)18.0f, (float)11.0f));
        PartDefinition bodyBack = body.m_171599_("body_back", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-3.0f, -2.0f, -2.0f, 6.0f, 5.0f, 5.0f, size), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tail = bodyBack.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 27).m_171488_(-2.0f, -1.0f, -1.0f, 4.0f, 3.0f, 12.0f, size), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        tail.m_171599_("tail_end", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-1.5f, -1.0f, -1.0f, 3.0f, 2.0f, 7.0f, size), PartPose.m_171423_((float)0.0f, (float)0.5f, (float)11.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(43, 11).m_171480_().m_171488_(-2.0f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f, size), PartPose.m_171419_((float)-4.0f, (float)18.0f, (float)-6.5f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(43, 11).m_171488_(-1.0f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f, size), PartPose.m_171419_((float)4.0f, (float)18.0f, (float)-6.5f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(43, 11).m_171480_().m_171488_(-2.0f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f, size), PartPose.m_171419_((float)-4.0f, (float)18.0f, (float)6.5f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(43, 11).m_171488_(-1.0f, -1.0f, -1.5f, 3.0f, 7.0f, 3.0f, size), PartPose.m_171419_((float)4.0f, (float)18.0f, (float)6.5f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.f_170854_.f_104203_ = Mth.m_14089_((float)((float)((double)(limbSwing * 0.6662f) + Math.PI))) * 1.4f * limbSwingAmount;
        this.f_170852_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.f_170855_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.f_170853_.f_104203_ = Mth.m_14089_((float)((float)((double)(limbSwing * 0.6662f) + Math.PI))) * 1.4f * limbSwingAmount;
        this.f_103492_.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.f_103492_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        float moveAmount = Mth.m_14089_((float)(ageInTicks * 0.2f)) * 0.52f + Mth.m_14089_((float)((float)((double)(limbSwing * 0.6662f) + Math.PI))) * limbSwingAmount;
        this.bodyBack.f_104204_ = moveAmount / 4.0f;
        this.tail.f_104204_ = moveAmount / 2.0f;
        this.tailEnd.f_104204_ = moveAmount;
    }

    public Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.f_103493_, (Object)this.f_170854_, (Object)this.f_170855_, (Object)this.f_170852_, (Object)this.f_170853_);
    }

    public Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.f_103492_);
    }
}

