/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.arseng.me.cell;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.cells.StorageCell;
import gripe._90.arseng.me.cell.ISourceCellItem;
import gripe._90.arseng.me.key.SourceKey;
import gripe._90.arseng.me.key.SourceKeyType;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class SourceCellInventory
implements StorageCell {
    private static final String AMOUNT = "amount";
    private final ISourceCellItem cellType;
    private final ItemStack i;
    private final ISaveProvider container;
    private long sourceAmount;
    private boolean isPersisted = true;

    public SourceCellInventory(ISourceCellItem cellType, ItemStack o, ISaveProvider container) {
        this.cellType = cellType;
        this.i = o;
        this.container = container;
        this.sourceAmount = this.getTag().m_128454_(AMOUNT);
    }

    public long getTotalBytes() {
        return this.cellType.getTotalBytes();
    }

    public long getUsedBytes() {
        int amountPerByte = SourceKeyType.TYPE.getAmountPerByte();
        return (this.sourceAmount + (long)amountPerByte - 1L) / (long)amountPerByte;
    }

    public long getMaxSource() {
        return this.cellType.getTotalBytes() * (long)SourceKeyType.TYPE.getAmountPerByte();
    }

    private CompoundTag getTag() {
        return this.i.m_41784_();
    }

    public CellState getStatus() {
        if (this.sourceAmount == 0L) {
            return CellState.EMPTY;
        }
        if (this.sourceAmount == this.getMaxSource()) {
            return CellState.FULL;
        }
        if (this.sourceAmount > this.getMaxSource() / 2L) {
            return CellState.TYPES_FULL;
        }
        return CellState.NOT_EMPTY;
    }

    public double getIdleDrain() {
        return this.cellType.getIdleDrain();
    }

    protected void saveChanges() {
        this.isPersisted = false;
        if (this.container != null) {
            this.container.saveChanges();
        } else {
            this.persist();
        }
    }

    public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
        if (amount == 0L || !(what instanceof SourceKey) || this.sourceAmount == this.getMaxSource()) {
            return 0L;
        }
        long remainingAmount = Math.max(0L, this.getMaxSource() - this.sourceAmount);
        if (amount > remainingAmount) {
            amount = remainingAmount;
        }
        if (mode == Actionable.MODULATE) {
            this.sourceAmount += amount;
            this.saveChanges();
        }
        return amount;
    }

    public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
        long extractAmount = Math.min(Integer.MAX_VALUE, amount);
        long currentAmount = this.sourceAmount;
        if (this.sourceAmount > 0L && Objects.equals(SourceKey.KEY, what)) {
            if (mode == Actionable.MODULATE) {
                this.sourceAmount = Math.max(0L, this.sourceAmount - extractAmount);
                this.saveChanges();
            }
            return Math.min(extractAmount, currentAmount);
        }
        return 0L;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        if (this.sourceAmount < 0L) {
            this.getTag().m_128473_(AMOUNT);
        } else {
            this.getTag().m_128356_(AMOUNT, this.sourceAmount);
        }
        this.isPersisted = true;
    }

    public void getAvailableStacks(KeyCounter out) {
        if (this.sourceAmount > 0L) {
            out.add(SourceKey.KEY, this.sourceAmount);
        }
    }

    public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
        return what instanceof SourceKey;
    }

    public Component getDescription() {
        return this.i.m_41786_();
    }
}

