/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra;

import com.mojang.logging.LogUtils;
import com.teamresourceful.resourcefulconfig.common.config.Configurator;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.data.PlanetData;
import earth.terrarium.ad_astra.common.entity.LunarianMerchantListener;
import earth.terrarium.ad_astra.common.networking.NetworkHandling;
import earth.terrarium.ad_astra.common.recipe.condition.IRecipeConditionSerializer;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModBlocks;
import earth.terrarium.ad_astra.common.registry.ModCriteria;
import earth.terrarium.ad_astra.common.registry.ModEntityTypes;
import earth.terrarium.ad_astra.common.registry.ModFeatures;
import earth.terrarium.ad_astra.common.registry.ModFluidProperties;
import earth.terrarium.ad_astra.common.registry.ModFluids;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.ad_astra.common.registry.ModMenus;
import earth.terrarium.ad_astra.common.registry.ModPaintings;
import earth.terrarium.ad_astra.common.registry.ModParticleTypes;
import earth.terrarium.ad_astra.common.registry.ModRecipeConditionSerializers;
import earth.terrarium.ad_astra.common.registry.ModRecipeSerializers;
import earth.terrarium.ad_astra.common.registry.ModRecipeTypes;
import earth.terrarium.ad_astra.common.registry.ModSoundEvents;
import earth.terrarium.ad_astra.common.registry.ModStructures;
import earth.terrarium.ad_astra.common.util.PlatformUtils;
import java.util.function.BiConsumer;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;

public class AdAstra {
    public static final String MOD_ID = "ad_astra";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Configurator CONFIGURATOR = new Configurator(true);

    public static void init() {
        CONFIGURATOR.registerConfig(AdAstraConfig.class);
        ModFluidProperties.FLUID_TYPES.initialize();
        ModFluids.FLUIDS.init();
        ModEntityTypes.ENTITY_TYPES.init();
        ModBlocks.BLOCKS.init();
        ModItems.ITEMS.init();
        ModBlockEntityTypes.BLOCK_ENTITY_TYPES.init();
        ModRecipeTypes.RECIPE_TYPES.init();
        ModRecipeSerializers.RECIPE_SERIALIZERS.init();
        ModRecipeConditionSerializers.init();
        ModMenus.MENUS.init();
        ModSoundEvents.SOUND_EVENTS.init();
        ModParticleTypes.PARTICLE_TYPES.init();
        ModPaintings.PAINTING_VARIANTS.init();
        ModFeatures.FEATURES.init();
        ModStructures.STRUCTURE_TYPES.init();
        ModStructures.STRUCTURE_PROCESSORS.init();
        ModCriteria.init();
        NetworkHandling.init();
    }

    public static void onRegisterReloadListeners(BiConsumer<ResourceLocation, PreparableReloadListener> registry) {
        registry.accept(new ResourceLocation(MOD_ID, "planet_data"), (PreparableReloadListener)new PlanetData());
        registry.accept(new ResourceLocation(MOD_ID, "lunarian_merchant_listener"), (PreparableReloadListener)new LunarianMerchantListener());
    }

    public static void postInit() {
        CauldronInteraction.f_175607_.put((Item)ModItems.SPACE_HELMET.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ModItems.SPACE_SUIT.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ModItems.SPACE_PANTS.get(), CauldronInteraction.f_175615_);
        CauldronInteraction.f_175607_.put((Item)ModItems.SPACE_BOOTS.get(), CauldronInteraction.f_175615_);
        PlatformUtils.registerStrippedLog((Block)ModBlocks.GLACIAN_LOG.get(), (Block)ModBlocks.STRIPPED_GLACIAN_LOG.get());
        for (IRecipeConditionSerializer<?> recipeConditionSerializer : ModRecipeConditionSerializers.getSerializers()) {
            PlatformUtils.registerRecipeConditionSerializer(recipeConditionSerializer);
        }
        ModEntityTypes.registerSpawnPlacements();
    }
}

