/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.recipe;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.common.util.NonNullFunction;

public abstract class BaseRecipeProvider
extends RecipeProvider {
    protected BaseRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    protected void blastingAndSmelting(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source) {
        this.blastingAndSmelting(consumer, name, nameToIdConverter, result, source, 1.0f, 200);
    }

    protected void blastingAndSmelting(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source, float xp, int smeltingTime) {
        this.blasting(consumer, name, nameToIdConverter, result, source, xp, smeltingTime / 2);
        this.smelting(consumer, name, nameToIdConverter, result, source, xp, smeltingTime);
    }

    protected void blasting(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source) {
        this.blasting(consumer, name, nameToIdConverter, result, source, 1.0f, 100);
    }

    protected void blasting(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source, ICondition ... conditions) {
        this.blasting(consumer, name, nameToIdConverter, result, source, 1.0f, 100, conditions);
    }

    protected void blasting(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source, float xp, int time) {
        SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{source.get()}), (ItemLike)result.get(), (float)xp, (int)time).m_126132_("has_item", (CriterionTriggerInstance)BaseRecipeProvider.m_125977_((ItemLike)source.get())).m_126140_(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("blasting/" + name)));
    }

    protected void blasting(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source, float xp, int time, ICondition ... conditions) {
        BaseRecipeProvider.conditionalBuilder(conditions).addRecipe(arg_0 -> ((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{source.get()}), (ItemLike)result.get(), (float)xp, (int)time).m_126132_("has_item", (CriterionTriggerInstance)BaseRecipeProvider.m_125977_((ItemLike)source.get()))).m_176498_(arg_0)).build(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("blasting/" + name)));
    }

    protected void smelting(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source) {
        this.smelting(consumer, name, nameToIdConverter, result, source, 1.0f, 200);
    }

    protected void smelting(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source, ICondition ... conditions) {
        this.smelting(consumer, name, nameToIdConverter, result, source, 1.0f, 200, conditions);
    }

    protected void smelting(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source, float xp, int time) {
        SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{source.get()}), (ItemLike)result.get(), (float)xp, (int)time).m_126132_("has_item", (CriterionTriggerInstance)BaseRecipeProvider.m_125977_((ItemLike)source.get())).m_126140_(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("smelting/" + name)));
    }

    protected void smelting(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> source, float xp, int time, ICondition ... conditions) {
        BaseRecipeProvider.conditionalBuilder(conditions).addRecipe(arg_0 -> ((SimpleCookingRecipeBuilder)SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{source.get()}), (ItemLike)result.get(), (float)xp, (int)time).m_126132_("has_item", (CriterionTriggerInstance)BaseRecipeProvider.m_125977_((ItemLike)source.get()))).m_176498_(arg_0)).build(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("smelting/" + name)));
    }

    protected void storageBlock3x3(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, String group, Supplier<? extends ItemLike> component, Supplier<? extends ItemLike> storage) {
        ShapelessRecipeBuilder.m_126189_((ItemLike)storage.get()).m_126211_(component.get(), 9).m_126145_(group).m_126132_(name + "_has_storage", (CriterionTriggerInstance)BaseRecipeProvider.m_125977_((ItemLike)component.get())).m_126140_(consumer, (ResourceLocation)nameToIdConverter.apply((Object)(name + "_component_to_storage")));
        ShapelessRecipeBuilder.m_126191_((ItemLike)component.get(), (int)9).m_126209_(storage.get()).m_126145_(group).m_126132_("has_item", (CriterionTriggerInstance)BaseRecipeProvider.m_125977_((ItemLike)storage.get())).m_126140_(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("crafting/" + name + "_storage_to_component")));
    }

    protected void storageBlock2x2(Consumer<FinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, String group, Supplier<? extends ItemLike> component, Supplier<? extends ItemLike> storage) {
        ShapedRecipeBuilder.m_126116_((ItemLike)storage.get()).m_126127_(Character.valueOf('X'), component.get()).m_126130_("XX").m_126130_("XX").m_126145_(group).m_126132_(name + "_has_storage", (CriterionTriggerInstance)BaseRecipeProvider.m_125977_((ItemLike)component.get())).m_126140_(consumer, (ResourceLocation)nameToIdConverter.apply((Object)(name + "_component_to_storage2x2")));
        ShapelessRecipeBuilder.m_126191_((ItemLike)component.get(), (int)4).m_126209_(storage.get()).m_126145_(group).m_126132_("has_item", (CriterionTriggerInstance)BaseRecipeProvider.m_125977_((ItemLike)storage.get())).m_126140_(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("crafting/" + name + "_storage2x2_to_component")));
    }

    protected static void recipeWithAlternativeTag(Consumer<FinishedRecipe> c, ResourceLocation name, @Nullable ResourceLocation alternativeName, TagKey<Item> tag, @Nullable TagKey<Item> alternativeTag, Function<TagKey<Item>, ShapedRecipeBuilder> recipe) {
        if (null == alternativeTag || null == alternativeName) {
            recipe.apply(tag).m_126140_(c, name);
        } else {
            BaseRecipeProvider.conditionalBuilder(BaseRecipeProvider.not((ICondition)new TagEmptyCondition(tag.f_203868_()))).addRecipe(arg_0 -> ((ShapedRecipeBuilder)recipe.apply(tag)).m_176498_(arg_0)).build(c, name);
            BaseRecipeProvider.conditionalBuilder(new ICondition[]{new TagEmptyCondition(tag.f_203868_())}).addRecipe(arg_0 -> ((ShapedRecipeBuilder)recipe.apply(alternativeTag)).m_176498_(arg_0)).build(c, alternativeName);
        }
    }

    protected static ICondition not(ICondition condition) {
        return new NotCondition(condition);
    }

    protected static ICondition and(ICondition ... conditions) {
        return new AndCondition(conditions);
    }

    protected static ICondition or(ICondition ... conditions) {
        return new OrCondition(conditions);
    }

    protected static ICondition modLoaded(String modId) {
        return new ModLoadedCondition(modId);
    }

    protected static ConditionalRecipe.Builder conditionalBuilder(ICondition ... conditions) {
        if (0 == conditions.length) {
            throw new IllegalArgumentException("No conditions were provided");
        }
        ConditionalRecipe.Builder builder = ConditionalRecipe.builder();
        for (ICondition condition : conditions) {
            builder.addCondition(condition);
        }
        return builder;
    }
}

