/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.stack;

import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.stack.IStackAdapter;
import it.zerono.mods.zerocore.lib.data.stack.IStackHolder;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.ObjIntConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public abstract class AbstractStackHolder<Holder extends AbstractStackHolder<Holder, Stack>, Stack>
implements IStackHolder<Holder, Stack> {
    private final BiPredicate<Integer, Stack> _stackValidator;
    private ObjIntConsumer<IStackHolder.ChangeType> _onChangeListener;
    private Runnable _onLoadListener;
    private Int2IntFunction _maxCapacityProvider;

    protected AbstractStackHolder() {
        this(AbstractStackHolder::defaultValidator);
    }

    protected AbstractStackHolder(BiPredicate<Integer, Stack> stackValidator) {
        this._stackValidator = Objects.requireNonNull(stackValidator);
        this._onChangeListener = (change, index) -> {};
        this._onLoadListener = CodeHelper.VOID_RUNNABLE;
        this._maxCapacityProvider = $ -> 0;
    }

    protected void onLoad() {
        this._onLoadListener.run();
    }

    protected void onChange(IStackHolder.ChangeType change, int index) {
        this._onChangeListener.accept(change, index);
    }

    protected <StackType, ContentType> void syncFrom(CompoundTag data, IStackAdapter<StackType, ContentType> adapter, Int2ObjectFunction<List<StackType>> itemsListSupplier) {
        List stacks = (List)itemsListSupplier.get(data.m_128451_("Size"));
        ListTag tagList = data.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= stacks.size()) continue;
            stacks.set(slot, adapter.readFrom(itemTags));
        }
        this.onLoad();
    }

    protected <StackType, ContentType> CompoundTag syncTo(CompoundTag data, List<StackType> items, IStackAdapter<StackType, ContentType> adapter) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < items.size(); ++i) {
            if (adapter.isEmpty(items.get(i))) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("Slot", i);
            adapter.writeTo(items.get(i), itemTag);
            nbtTagList.add((Object)itemTag);
        }
        data.m_128365_("Items", (Tag)nbtTagList);
        data.m_128405_("Size", items.size());
        return data;
    }

    @Override
    public boolean isStackValid(int index, Stack stack) {
        return this._stackValidator.test(index, stack);
    }

    @Override
    public Holder setOnContentsChangedListener(ObjIntConsumer<IStackHolder.ChangeType> listener) {
        this._onChangeListener = Objects.requireNonNull(listener);
        return (Holder)this;
    }

    @Override
    public Holder setOnLoadListener(Runnable listener) {
        this._onLoadListener = Objects.requireNonNull(listener);
        return (Holder)this;
    }

    @Override
    public void setMaxCapacity(Int2IntFunction maxCapacity) {
        this._maxCapacityProvider = Objects.requireNonNull(maxCapacity);
    }

    @Override
    public int getMaxCapacity(int index) {
        return this._maxCapacityProvider.applyAsInt(index);
    }

    protected static <Stack> boolean defaultValidator(Integer index, Stack stack) {
        return true;
    }
}

