/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render.builder;

import com.mojang.math.Vector3f;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.Vertex;
import it.zerono.mods.zerocore.lib.client.render.builder.IPrimitiveBuilder;
import it.zerono.mods.zerocore.lib.data.geometry.Vector3d;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.data.gfx.LightMap;
import it.zerono.mods.zerocore.lib.data.gfx.UV;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VertexBuilder
implements IPrimitiveBuilder<Vertex> {
    private final boolean _autoReset;
    private int _idx;
    private Vector3d _position;
    private Vector3f _normal;
    private UV _uv;
    private Colour _colour;
    private LightMap _lightMap;
    private LightMap _overlayMap;
    private static VertexBuilder s_defaultBuilder = null;

    public static VertexBuilder getDefaultBuilder() {
        if (null == s_defaultBuilder) {
            s_defaultBuilder = new VertexBuilder(false);
        }
        return s_defaultBuilder;
    }

    public VertexBuilder(boolean autoReset) {
        this._autoReset = autoReset;
    }

    @Override
    public Vertex build() {
        Vertex vertex = new Vertex(this._position, this._normal, this._uv, this._colour, this._lightMap, this._overlayMap);
        vertex.IDX = this._idx;
        if (this._autoReset) {
            this.reset();
        }
        return vertex;
    }

    @Override
    public void reset() {
        this._idx = 0;
        this._position = null;
        this._normal = null;
        this._uv = null;
        this._colour = null;
        this._overlayMap = null;
        this._lightMap = null;
    }

    public VertexBuilder setIdx(int idx) {
        this._idx = idx;
        return this;
    }

    public VertexBuilder setTexture(UV uv) {
        this._uv = uv;
        return this;
    }

    public VertexBuilder setTexture(float u, float v) {
        return this.setTexture(new UV(u, v));
    }

    public VertexBuilder setTexture(TextureAtlasSprite sprite) {
        return this.setTexture(new UV(sprite.m_118409_(), sprite.m_118411_()));
    }

    public VertexBuilder setTexture(ISprite sprite) {
        return this.setTexture(new UV(sprite.getMinU(), sprite.getMinV()));
    }

    public VertexBuilder setTexture(Supplier<ISprite> sprite) {
        return this.setTexture(sprite.get());
    }

    public VertexBuilder setLightMap(LightMap map) {
        this._lightMap = map;
        return this;
    }

    public VertexBuilder setLightMap(int sky, int block) {
        return this.setLightMap(new LightMap(sky, block));
    }

    public VertexBuilder setLightMap(int combined) {
        return this.setLightMap(new LightMap(combined));
    }

    public VertexBuilder setOverlayMap(LightMap map) {
        this._overlayMap = map;
        return this;
    }

    public VertexBuilder setOverlayMap(int sky, int block) {
        return this.setOverlayMap(new LightMap(sky, block));
    }

    public VertexBuilder setOverlayMap(int combined) {
        return this.setOverlayMap(new LightMap(combined));
    }

    public VertexBuilder setColour(Colour colour) {
        this._colour = colour;
        return this;
    }

    public VertexBuilder setColour(int red, int green, int blue, int alpha) {
        return this.setColour(new Colour(red, green, blue, alpha));
    }

    public VertexBuilder setColour(double red, double green, double blue, double alpha) {
        return this.setColour(new Colour(red, green, blue, alpha));
    }

    public VertexBuilder setPosition(Vector3d position) {
        this._position = position;
        return this;
    }

    public VertexBuilder setPosition(double x, double y, double z) {
        return this.setPosition(new Vector3d(x, y, z));
    }

    public VertexBuilder setNormal(Vector3f normal) {
        this._normal = normal;
        return this;
    }

    public VertexBuilder setNormal(int x, int y, int z) {
        return this.setNormal(new Vector3f((float)x, (float)y, (float)z));
    }
}

