/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.vanillaaiots.util;

import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ToolUtil {
    public static final Set<ToolAction> DEFAULT_AIOT_ACTIONS = Set.of(ToolActions.AXE_DIG, ToolActions.AXE_STRIP, ToolActions.AXE_SCRAPE, ToolActions.AXE_WAX_OFF, ToolActions.HOE_DIG, ToolActions.HOE_TILL, ToolActions.SHOVEL_DIG, ToolActions.SHOVEL_FLATTEN, ToolActions.PICKAXE_DIG, ToolActions.SWORD_DIG);

    public static InteractionResult toolUse(UseOnContext context, ToolAction toolAction) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        Direction side = context.m_43719_();
        if (player != null && player.m_36204_(pos, side, stack) && (side != Direction.DOWN && level.m_46859_(pos.m_7494_()) || ToolActions.AXE_STRIP == toolAction)) {
            BlockState state = level.m_8055_(pos);
            BlockState modifiedState = state.getToolModifiedState(context, toolAction, false);
            if (toolAction == ToolActions.HOE_TILL) {
                modifiedState = ToolUtil.getHoeTillingState(state, context);
                if (state.m_60734_() == Blocks.f_152549_) {
                    Block.m_152435_((Level)level, (BlockPos)pos, (Direction)side, (ItemStack)new ItemStack((ItemLike)Items.f_151017_));
                }
            }
            if (modifiedState != null) {
                SoundEvent sound = ToolActions.DEFAULT_AXE_ACTIONS.contains(toolAction) ? (toolAction == ToolActions.AXE_STRIP ? SoundEvents.f_11688_ : (toolAction == ToolActions.AXE_SCRAPE ? SoundEvents.f_144059_ : SoundEvents.f_144060_)) : (ToolActions.DEFAULT_SHOVEL_ACTIONS.contains(toolAction) ? SoundEvents.f_12406_ : SoundEvents.f_11955_);
                level.m_5594_(player, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (state.m_60734_() instanceof CampfireBlock && ((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                if (!level.f_46443_) {
                    level.m_5898_(player, 1009, pos, 0);
                }
                CampfireBlock.m_152749_((Entity)player, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
                modifiedState = (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false));
            }
            if (modifiedState != null) {
                if (!level.f_46443_) {
                    level.m_7731_(pos, modifiedState, 11);
                    stack.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21190_(context.m_43724_()));
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public static BlockState getHoeTillingState(BlockState state, UseOnContext context) {
        Block block = state.m_60734_();
        if (block == Blocks.f_152549_) {
            return Blocks.f_50493_.m_49966_();
        }
        if (context.m_43719_() != Direction.DOWN && context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60795_()) {
            if (block == Blocks.f_50440_ || block == Blocks.f_152481_ || block == Blocks.f_50493_) {
                return Blocks.f_50093_.m_49966_();
            }
            if (block == Blocks.f_50546_) {
                return Blocks.f_50493_.m_49966_();
            }
        }
        return null;
    }
}

