/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.vanillaaiots.items;

import de.melanx.vanillaaiots.compat.LibCompat;
import de.melanx.vanillaaiots.config.ModConfig;
import de.melanx.vanillaaiots.data.AIOTTags;
import de.melanx.vanillaaiots.tools.ToolMaterials;
import de.melanx.vanillaaiots.util.ComponentUtil;
import de.melanx.vanillaaiots.util.ToolUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class BaseAiot
extends DiggerItem {
    private final boolean isVanilla;

    public BaseAiot(float attackDamageModifier, float attackSpeedModifier, Tier tier, Item.Properties properties) {
        super(attackDamageModifier, attackSpeedModifier, tier, AIOTTags.MINEABLE_WITH_AIOT, properties);
        this.isVanilla = tier == ToolMaterials.WOODEN || tier == ToolMaterials.STONE || tier == ToolMaterials.IRON || tier == ToolMaterials.GOLDEN || tier == ToolMaterials.DIAMOND || tier == ToolMaterials.NETHERITE;
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack item = context.m_43722_();
        boolean hoemode = BaseAiot.isHoemode(item);
        InteractionResult result = InteractionResult.PASS;
        for (ToolAction action : ToolActions.DEFAULT_AXE_ACTIONS) {
            if (result != InteractionResult.PASS) break;
            result = ToolUtil.toolUse(context, action);
        }
        if (result == InteractionResult.PASS) {
            result = hoemode ? ToolUtil.toolUse(context, ToolActions.HOE_TILL) : ToolUtil.toolUse(context, ToolActions.SHOVEL_FLATTEN);
        }
        return result;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.f_46443_ && player.m_6047_()) {
            Style dark_blue = Style.f_131099_.m_131140_(ChatFormatting.DARK_BLUE);
            Style aqua = Style.f_131099_.m_131140_(ChatFormatting.AQUA);
            MutableComponent text = ComponentUtil.getTooltip("toggleMode", new Object[0]).m_130946_(": ").m_130948_(dark_blue);
            MutableComponent pathMode = ComponentUtil.getTooltip("pathMode", Blocks.f_152481_.m_49954_().getString()).m_130948_(aqua);
            MutableComponent hoeMode = ComponentUtil.getTooltip("hoeMode", new Object[0]).m_130948_(aqua);
            if (BaseAiot.isHoemode(stack)) {
                BaseAiot.setHoemode(stack, false);
                text = text.m_7220_((Component)pathMode);
            } else {
                BaseAiot.setHoemode(stack, true);
                text = text.m_7220_((Component)hoeMode);
            }
            player.m_5661_((Component)text, true);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    public int getBurnTime(@Nonnull ItemStack stack, @Nullable RecipeType<?> recipeType) {
        return this.m_43314_() == ToolMaterials.WOODEN ? 400 : 0;
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    public float m_8102_(@Nonnull ItemStack stack, @Nonnull BlockState state) {
        if (state.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        return super.m_8102_(stack, state);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolUtil.DEFAULT_AIOT_ACTIONS.contains(toolAction);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return (this.m_43314_() != ToolMaterials.SLIME || enchantment != Enchantments.f_44980_) && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag isAdvanced) {
        if (LibCompat.isMoreVanillaLibLoaded()) {
            LibCompat.editHoverText(this, stack, level, tooltip, isAdvanced);
        }
        super.m_7373_(stack, level, tooltip, isAdvanced);
    }

    public void m_6787_(@Nonnull CreativeModeTab category, @Nonnull NonNullList<ItemStack> items) {
        if (!this.isVanilla && ModConfig.vanillaOnly) {
            return;
        }
        super.m_6787_(category, items);
    }

    private static void setHoemode(ItemStack stack, boolean b) {
        stack.m_41784_().m_128379_("hoemode", b);
    }

    public int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        BaseAiot item;
        Item item2;
        if (enchantment == Enchantments.f_44980_ && (item2 = stack.m_41720_()) instanceof BaseAiot && (item = (BaseAiot)item2).m_43314_() == ToolMaterials.SLIME) {
            return 3;
        }
        return super.getEnchantmentLevel(stack, enchantment);
    }

    private static boolean isHoemode(ItemStack stack) {
        return stack.m_41619_() || !stack.m_41784_().m_128441_("hoemode") || stack.m_41784_().m_128471_("hoemode");
    }
}

