/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.wireless;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.registration.ModBlocks;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.ticks.TickPriority;

public class WirelessStorage
extends SavedData {
    public static final String ID = UtilitiX.getInstance().modid + "_wireless";
    private final Map<UUID, Map<GlobalPos, Integer>> signals = new HashMap<UUID, Map<GlobalPos, Integer>>();

    public static WirelessStorage get(Level level) {
        if (!level.f_46443_) {
            DimensionDataStorage storage = ((ServerLevel)level).m_7654_().m_129783_().m_8895_();
            return (WirelessStorage)storage.m_164861_(nbt -> new WirelessStorage().load((CompoundTag)nbt), WirelessStorage::new, ID);
        }
        return new WirelessStorage();
    }

    @Nonnull
    public WirelessStorage load(@Nonnull CompoundTag nbt) {
        this.signals.clear();
        ListTag list = nbt.m_128437_("Signals", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.m_128728_(i);
            UUID uid = tag.m_128342_("K");
            ListTag entries = tag.m_128437_("V", 10);
            HashMap<GlobalPos, Integer> signalMap = new HashMap<GlobalPos, Integer>();
            for (int j = 0; j < entries.size(); ++j) {
                CompoundTag cmp = entries.m_128728_(j);
                try {
                    GlobalPos pos = GlobalPos.m_122643_((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)Objects.requireNonNull(ResourceLocation.m_135820_((String)cmp.m_128461_("L")))), (BlockPos)BlockPos.m_122022_((long)cmp.m_128454_("P")));
                    int strength = cmp.m_128451_("R");
                    signalMap.put(pos, strength);
                    continue;
                }
                catch (NullPointerException e) {
                    UtilitiX.getInstance().logger.warn("Invalid level loaded", (Throwable)e);
                }
            }
            this.signals.put(uid, signalMap);
        }
        return this;
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        ListTag list = new ListTag();
        for (Map.Entry<UUID, Map<GlobalPos, Integer>> entry : this.signals.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("K", entry.getKey());
            ListTag entries = new ListTag();
            for (Map.Entry<GlobalPos, Integer> signal : entry.getValue().entrySet()) {
                CompoundTag cmp = new CompoundTag();
                cmp.m_128359_("L", signal.getKey().m_122640_().m_135782_().toString());
                cmp.m_128356_("P", signal.getKey().m_122646_().m_121878_());
                cmp.m_128405_("R", signal.getValue().intValue());
                entries.add((Object)cmp);
            }
            tag.m_128365_("V", (Tag)entries);
            list.add((Object)tag);
        }
        compound.m_128365_("Signals", (Tag)list);
        return compound;
    }

    public int getStrength(UUID uid) {
        if (!this.signals.containsKey(uid)) {
            return 0;
        }
        return this.signals.get(uid).values().stream().max(Integer::compareTo).orElse(0);
    }

    public void update(Level level, UUID uid, GlobalPos pos, int strength) {
        Map<GlobalPos, Integer> uidMap;
        if (!this.signals.containsKey(uid)) {
            this.signals.put(uid, new HashMap());
            this.m_77762_();
        }
        if (!(uidMap = this.signals.get(uid)).containsKey(pos) || uidMap.get(pos) != strength) {
            uidMap.put(pos, strength);
            if (level instanceof ServerLevel) {
                for (GlobalPos targetPos : uidMap.keySet()) {
                    ServerLevel targetLevel;
                    if (pos.equals((Object)targetPos) || (targetLevel = ((ServerLevel)level).m_7654_().m_129880_(targetPos.m_122640_())) == null) continue;
                    targetLevel.m_186464_(targetPos.m_122646_(), (Block)ModBlocks.linkedRepeater, 1, TickPriority.HIGH);
                }
            }
            this.m_77762_();
        }
    }

    public void remove(Level level, @Nullable UUID uid, GlobalPos pos) {
        if (uid != null) {
            if (this.signals.containsKey(uid)) {
                if (this.signals.get(uid).remove(pos) != null) {
                    if (level instanceof ServerLevel) {
                        for (GlobalPos targetPos : this.signals.get(uid).keySet()) {
                            ServerLevel targetLevel;
                            if (pos.equals((Object)targetPos) || (targetLevel = ((ServerLevel)level).m_7654_().m_129880_(targetPos.m_122640_())) == null) continue;
                            targetLevel.m_186464_(targetPos.m_122646_(), (Block)ModBlocks.linkedRepeater, 1, TickPriority.HIGH);
                        }
                    }
                    this.m_77762_();
                }
                if (this.signals.get(uid).isEmpty()) {
                    this.signals.remove(uid);
                    this.m_77762_();
                }
            }
        } else {
            this.signals.keySet().forEach(x -> this.remove(level, (UUID)x, pos));
        }
    }
}

