/*
 * Decompiled with CFR 0.152.
 */
package jackyy.simplesponge.item;

import jackyy.gunpowderlib.capability.FEItemStackCapability;
import jackyy.gunpowderlib.capability.FEStorageCapability;
import jackyy.gunpowderlib.capability.IFEContainer;
import jackyy.gunpowderlib.helper.EnergyHelper;
import jackyy.gunpowderlib.helper.NBTHelper;
import jackyy.gunpowderlib.helper.StringHelper;
import jackyy.simplesponge.item.ItemSpongeOnAStickBase;
import jackyy.simplesponge.registry.ModConfigs;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemEnergizedSpongeOnAStick
extends ItemSpongeOnAStickBase
implements IFEContainer {
    public ItemEnergizedSpongeOnAStick() {
        super(new Item.Properties().m_41487_(1).setNoRepair().m_41497_(Rarity.RARE));
    }

    @Override
    public int getEnergy() {
        return (Integer)ModConfigs.CONFIG.energizedSpongeOnAStickMaxEnergy.get();
    }

    @Override
    public int getPerRightClickUse() {
        return (Integer)ModConfigs.CONFIG.energizedSpongeOnAStickPerRightClickUse.get();
    }

    @Override
    public int getRange() {
        return (Integer)ModConfigs.CONFIG.energizedSpongeOnAStickRange.get();
    }

    @Override
    public boolean isMagmatic() {
        return true;
    }

    @Override
    public boolean isPowered() {
        return true;
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.m_220152_(tab) && ((Boolean)ModConfigs.CONFIG.enableEnergizedSpongeOnAStick.get()).booleanValue()) {
            ItemStack empty = new ItemStack((ItemLike)this);
            items.add((Object)empty);
            ItemStack full = new ItemStack((ItemLike)this);
            EnergyHelper.setDefaultEnergyTag((ItemStack)full, (int)this.getMaxEnergyStored(full));
            items.add((Object)full);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)StringHelper.formatNumber((long)this.getEnergyStored(stack)).m_130946_(" / ").m_7220_((Component)StringHelper.formatNumber((long)this.getMaxEnergyStored(stack))).m_130946_(" FE"));
    }

    public int m_142158_(ItemStack stack) {
        FEStorageCapability storage = (FEStorageCapability)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        if (storage == null) {
            return 0;
        }
        return (int)Math.round(13.0 * (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack));
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)0.33333334f, (float)1.0f, (float)1.0f);
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return EnergyHelper.receiveEnergy((ItemStack)container, (int)maxReceive, (boolean)simulate);
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return EnergyHelper.extractEnergy((ItemStack)container, (int)maxExtract, (boolean)simulate);
    }

    public int getEnergyStored(ItemStack container) {
        if (container.m_41783_() == null || !container.m_41783_().m_128441_("Energy")) {
            return 0;
        }
        return Math.min(NBTHelper.getInt((ItemStack)container, (String)"Energy"), this.getEnergy());
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getEnergy();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FEItemStackCapability((IEnergyStorage)new FEStorageCapability((IFEContainer)this, stack));
    }
}

