/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.mods.sandbox.datagen.ext;

import com.mojang.datafixers.util.Pair;
import io.github.noeppi_noeppi.mods.sandbox.SandBox;
import io.github.noeppi_noeppi.mods.sandbox.biome.BiomeLayer;
import io.github.noeppi_noeppi.mods.sandbox.biome.LayeredBiomeSource;
import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.SingleWorldGenData;
import io.github.noeppi_noeppi.mods.sandbox.datagen.ext.base.WorldGenData;
import io.github.noeppi_noeppi.mods.sandbox.gen.ExtendedNoiseGenerator;
import io.github.noeppi_noeppi.mods.sandbox.surface.SurfaceRuleSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class DimensionData
extends SingleWorldGenData<LevelStem> {
    public DimensionData(WorldGenData.Properties properties) {
        super(properties, Registry.f_122820_, LevelStem.f_63970_);
    }

    public BiomeSourceBuilder dimension(Holder<DimensionType> dimensionType) {
        return this.dimension(null, dimensionType);
    }

    public BiomeSourceBuilder dimension(ResourceKey<Level> key, Holder<DimensionType> dimensionType) {
        return new BiomeSourceBuilder(key, this.registries.holder(Registry.f_122818_, dimensionType));
    }

    public Holder<LevelStem> dimension(Holder<DimensionType> dimensionType, ChunkGenerator generator) {
        return this.dimension(null, dimensionType, generator);
    }

    public Holder<LevelStem> dimension(ResourceKey<Level> key, Holder<DimensionType> dimensionType, ChunkGenerator generator) {
        LevelStem stem = new LevelStem(this.registries.holder(Registry.f_122818_, dimensionType), generator);
        if (key != null) {
            this.registries.register(Registry.f_122820_, key.m_135782_(), stem);
        }
        return this.addToList(this.registries.holder(Registry.f_122820_, stem));
    }

    public class BiomeSourceBuilder {
        @Nullable
        private final ResourceKey<Level> key;
        private final Holder<DimensionType> dimensionType;

        private BiomeSourceBuilder(ResourceKey<Level> key, Holder<DimensionType> dimensionType) {
            this.key = key;
            this.dimensionType = dimensionType;
        }

        public ChunkGeneratorBuilder fixedBiome(ResourceKey<Biome> biome) {
            return this.fixedBiome((Holder<Biome>)DimensionData.this.holder(biome));
        }

        public ChunkGeneratorBuilder fixedBiome(Holder<Biome> biome) {
            return new ChunkGeneratorBuilder(this.key, this.dimensionType, (BiomeSource)new FixedBiomeSource(DimensionData.this.registries.holder(Registry.f_122885_, biome)));
        }

        public ChunkGeneratorBuilder multiNoiseBiome(Climate.ParameterList<Holder<Biome>> climate) {
            Climate.ParameterList cleanedClimate = new Climate.ParameterList(climate.m_186850_().stream().map(p -> Pair.of((Object)((Climate.ParameterPoint)p.getFirst()), DimensionData.this.registries.holder(Registry.f_122885_, (Holder)p.getSecond()))).toList());
            return new ChunkGeneratorBuilder(this.key, this.dimensionType, (BiomeSource)new MultiNoiseBiomeSource(cleanedClimate));
        }

        public ChunkGeneratorBuilder layeredBiome(double horizontalScale, double verticalScale, TagKey<BiomeLayer> layers) {
            return new ChunkGeneratorBuilder(this.key, this.dimensionType, new LayeredBiomeSource(horizontalScale, verticalScale, (HolderSet<BiomeLayer>)DimensionData.this.tag(layers)));
        }

        @SafeVarargs
        public final ChunkGeneratorBuilder layeredBiome(double horizontalScale, double verticalScale, Holder<BiomeLayer> ... layers) {
            return new ChunkGeneratorBuilder(this.key, this.dimensionType, new LayeredBiomeSource(horizontalScale, verticalScale, (HolderSet<BiomeLayer>)HolderSet.m_205809_(layers)));
        }
    }

    public class NoiseGeneratorBuilder {
        @Nullable
        private final ResourceKey<Level> key;
        private final Holder<DimensionType> dimensionType;
        private final BiomeSource biomes;
        private final Holder<NoiseGeneratorSettings> settings;
        @Nullable
        private Holder<SurfaceRuleSet> surfaceOverride;

        private NoiseGeneratorBuilder(ResourceKey<Level> key, Holder<DimensionType> dimensionType, BiomeSource biomes, Holder<NoiseGeneratorSettings> settings) {
            this.key = key;
            this.dimensionType = dimensionType;
            this.biomes = biomes;
            this.settings = settings;
            this.surfaceOverride = null;
        }

        public NoiseGeneratorBuilder surfaceOverride(Holder<SurfaceRuleSet> surface) {
            this.surfaceOverride = DimensionData.this.registries.holder(SandBox.SURFACE_RULE_SET_REGISTRY, surface);
            return this;
        }

        public Holder<LevelStem> build() {
            NoiseBasedChunkGenerator generator = this.surfaceOverride != null ? new ExtendedNoiseGenerator(DimensionData.this.registries.registry(Registry.f_122885_), DimensionData.this.registries.registry(SandBox.BIOME_SURFACE_REGISTRY), DimensionData.this.registries.registry(Registry.f_211073_), DimensionData.this.registries.registry(Registry.f_194568_), this.biomes, this.settings, Optional.of(this.surfaceOverride)) : new NoiseBasedChunkGenerator(DimensionData.this.registries.registry(Registry.f_211073_), DimensionData.this.registries.registry(Registry.f_194568_), this.biomes, this.settings);
            LevelStem stem = new LevelStem(this.dimensionType, (ChunkGenerator)generator);
            if (this.key != null) {
                DimensionData.this.registries.register(Registry.f_122820_, this.key.m_135782_(), stem);
            }
            return DimensionData.this.addToList(DimensionData.this.registries.holder(Registry.f_122820_, stem));
        }
    }

    public class FlatGeneratorBuilder {
        @Nullable
        private final ResourceKey<Level> key;
        private final Holder<DimensionType> dimensionType;
        private final List<Holder<StructureSet>> structures;
        private final List<FlatLayerInfo> layers;
        private final Holder<Biome> biome;
        private boolean lakes;
        private boolean decoration;

        private FlatGeneratorBuilder(ResourceKey<Level> key, Holder<DimensionType> dimensionType, BiomeSource biomes) {
            this.key = key;
            this.dimensionType = dimensionType;
            this.structures = new ArrayList<Holder<StructureSet>>();
            if (!(biomes instanceof FixedBiomeSource)) {
                throw new IllegalArgumentException("Flat generator can only be used with fixed biome source");
            }
            FixedBiomeSource source = (FixedBiomeSource)biomes;
            this.biome = DimensionData.this.registries.holder(Registry.f_122885_, source.f_48252_);
            this.layers = new ArrayList<FlatLayerInfo>();
            this.decoration = false;
        }

        public FlatGeneratorBuilder structures(Holder<StructureSet> structures) {
            this.structures.add(DimensionData.this.registries.holder(Registry.f_211073_, structures));
            return this;
        }

        public FlatGeneratorBuilder layer(Block block, int height) {
            if (height > 0) {
                this.layers.add(new FlatLayerInfo(height, block));
            }
            return this;
        }

        public FlatGeneratorBuilder withLakes() {
            this.lakes = true;
            return this;
        }

        public FlatGeneratorBuilder withDecoration() {
            this.decoration = true;
            return this;
        }

        public Holder<LevelStem> build() {
            if (this.layers.isEmpty()) {
                this.layers.add(new FlatLayerInfo(1, Blocks.f_50016_));
            }
            Optional structures = this.structures.isEmpty() ? Optional.empty() : Optional.of(HolderSet.m_205800_(List.copyOf(this.structures)));
            FlatLevelGeneratorSettings settings = new FlatLevelGeneratorSettings(DimensionData.this.registries.registry(Registry.f_122885_), structures, List.copyOf(this.layers), this.lakes, this.decoration, Optional.of(this.biome));
            FlatLevelSource generator = new FlatLevelSource(DimensionData.this.registries.registry(Registry.f_211073_), settings);
            LevelStem stem = new LevelStem(this.dimensionType, (ChunkGenerator)generator);
            if (this.key != null) {
                DimensionData.this.registries.register(Registry.f_122820_, this.key.m_135782_(), stem);
            }
            return DimensionData.this.addToList(DimensionData.this.registries.holder(Registry.f_122820_, stem));
        }
    }

    public class ChunkGeneratorBuilder {
        @Nullable
        private final ResourceKey<Level> key;
        private final Holder<DimensionType> dimensionType;
        private final BiomeSource biomes;

        private ChunkGeneratorBuilder(ResourceKey<Level> key, Holder<DimensionType> dimensionType, BiomeSource biomes) {
            this.key = key;
            this.dimensionType = dimensionType;
            this.biomes = biomes;
        }

        public FlatGeneratorBuilder flatGenerator() {
            return new FlatGeneratorBuilder(this.key, this.dimensionType, this.biomes);
        }

        public NoiseGeneratorBuilder noiseGenerator(Holder<NoiseGeneratorSettings> settings) {
            return new NoiseGeneratorBuilder(this.key, this.dimensionType, this.biomes, DimensionData.this.registries.holder(Registry.f_122878_, settings));
        }
    }
}

