/*
 * Decompiled with CFR 0.152.
 */
package giselle.rs_cmig.common;

import com.refinedmods.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorListener;
import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.apiimpl.network.node.CraftingMonitorNetworkNode;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.CraftingMonitorBlockEntity;
import com.refinedmods.refinedstorage.blockentity.craftingmonitor.ICraftingMonitor;
import giselle.rs_cmig.client.RS_CMIGClient;
import giselle.rs_cmig.common.CraftingMonitorListener;
import giselle.rs_cmig.common.EventHandlers;
import giselle.rs_cmig.common.LevelBlockPos;
import giselle.rs_cmig.common.network.CCraftingMonitorOpenResultMessage;
import giselle.rs_cmig.common.network.NetworkHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="rs_cmig")
public class RS_CMIG {
    public static final String MODID = "rs_cmig";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final NetworkHandler NETWORK_HANDLER = new NetworkHandler();
    private static final Map<INetwork, CraftingMonitorNetworkNode> NOCDE_CACHE = new HashMap<INetwork, CraftingMonitorNetworkNode>();
    private static final Map<UUID, List<CraftingMonitorListener>> LISTENERS = new HashMap<UUID, List<CraftingMonitorListener>>();

    public RS_CMIG() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> RS_CMIGClient::init);
        IEventBus fml_bus = FMLJavaModLoadingContext.get().getModEventBus();
        fml_bus.addListener(RS_CMIG::onCommonSetup);
        IEventBus forge_bus = MinecraftForge.EVENT_BUS;
        forge_bus.register(EventHandlers.class);
    }

    private static void onCommonSetup(FMLCommonSetupEvent e) {
        NETWORK_HANDLER.register();
    }

    public static void startMonitoring(ServerPlayer player, INetwork network) {
        CraftingMonitorBlockEntity craftingMontior = RS_CMIG.findCraftingMontior(network);
        if (craftingMontior != null) {
            CraftingMonitorListener listener = new CraftingMonitorListener(player, network, (ICraftingMonitor)craftingMontior.getNode());
            RS_CMIG.getMonitorings(player).add(listener);
            network.getCraftingManager().addListener((ICraftingMonitorListener)listener);
        }
    }

    public static void stopMonitoring(ServerPlayer player, INetwork network) {
        List<CraftingMonitorListener> list = RS_CMIG.getMonitorings(player);
        List filetered = list.stream().filter(l -> l.getNetwork() == network).collect(Collectors.toList());
        for (CraftingMonitorListener listener : filetered) {
            network.getCraftingManager().removeListener((ICraftingMonitorListener)listener);
            list.remove(listener);
        }
    }

    private static List<CraftingMonitorListener> getMonitorings(ServerPlayer player) {
        return LISTENERS.computeIfAbsent(player.m_20148_(), k -> new ArrayList());
    }

    public static INetwork getNetwork(ServerPlayer player, LevelBlockPos networkPos) {
        ResourceKey networkLevelKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)networkPos.getLevelName());
        ServerLevel networkLevel = player.m_20194_().m_129880_(networkLevelKey);
        return API.instance().getNetworkManager(networkLevel).getNetwork(networkPos.getPos());
    }

    public static void openGui(ServerPlayer player, INetwork network) {
        CraftingMonitorBlockEntity craftingMonitor = RS_CMIG.findCraftingMontior(network);
        CraftingMonitorNetworkNode node = (CraftingMonitorNetworkNode)craftingMonitor.getNode();
        NETWORK_HANDLER.sendTo(player, new CCraftingMonitorOpenResultMessage(new LevelBlockPos(node.getNetwork()), node.getTitle()));
    }

    public static CraftingMonitorBlockEntity findCraftingMontior(INetwork network) {
        CraftingMonitorBlockEntity blockEntity;
        BlockEntity blockEntity2;
        CraftingMonitorNetworkNode node = NOCDE_CACHE.get(network);
        if (node != null && (blockEntity2 = node.getLevel().m_7702_(node.getPos())) instanceof CraftingMonitorBlockEntity && ((CraftingMonitorNetworkNode)(blockEntity = (CraftingMonitorBlockEntity)blockEntity2).getNode()).getNetwork() == network) {
            return blockEntity;
        }
        CraftingMonitorBlockEntity craftingMonitorBlockEntity = RS_CMIG.findCraftingMontior0(network);
        if (craftingMonitorBlockEntity != null) {
            NOCDE_CACHE.put(network, (CraftingMonitorNetworkNode)craftingMonitorBlockEntity.getNode());
        } else {
            NOCDE_CACHE.remove(network);
        }
        return craftingMonitorBlockEntity;
    }

    private static CraftingMonitorBlockEntity findCraftingMontior0(INetwork network) {
        if (network == null) {
            return null;
        }
        for (INetworkNodeGraphEntry entry : network.getNodeGraph().all()) {
            INetworkNode iNetworkNode = entry.getNode();
            if (!(iNetworkNode instanceof CraftingMonitorNetworkNode)) continue;
            CraftingMonitorNetworkNode node = (CraftingMonitorNetworkNode)iNetworkNode;
            BlockPos pos = node.getPos();
            Level level = node.getLevel();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof CraftingMonitorBlockEntity)) continue;
            CraftingMonitorBlockEntity blockEntity2 = (CraftingMonitorBlockEntity)blockEntity;
            return blockEntity2;
        }
        return null;
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }
}

