/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.biome.v1;

import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public interface GenerationSettingsContext {
    public boolean removeFeature(GenerationStep.Decoration var1, ResourceKey<PlacedFeature> var2);

    default public boolean removeFeature(ResourceKey<PlacedFeature> featureKey) {
        boolean anyFound = false;
        for (GenerationStep.Decoration step : GenerationStep.Decoration.values()) {
            if (!this.removeFeature(step, featureKey)) continue;
            anyFound = true;
        }
        return anyFound;
    }

    default public boolean removeBuiltInFeature(PlacedFeature feature) {
        return this.removeFeature((ResourceKey<PlacedFeature>)((ResourceKey)BuiltinRegistries.f_194653_.m_7854_((Object)feature).orElseThrow()));
    }

    default public boolean removeBuiltInFeature(GenerationStep.Decoration step, PlacedFeature feature) {
        return this.removeFeature(step, (ResourceKey<PlacedFeature>)((ResourceKey)BuiltinRegistries.f_194653_.m_7854_((Object)feature).orElseThrow()));
    }

    public void addFeature(GenerationStep.Decoration var1, ResourceKey<PlacedFeature> var2);

    default public void addBuiltInFeature(GenerationStep.Decoration step, PlacedFeature feature) {
        this.addFeature(step, (ResourceKey<PlacedFeature>)((ResourceKey)BuiltinRegistries.f_194653_.m_7854_((Object)feature).orElseThrow()));
    }

    public void addCarver(GenerationStep.Carving var1, ResourceKey<ConfiguredWorldCarver<?>> var2);

    default public void addBuiltInCarver(GenerationStep.Carving step, ConfiguredWorldCarver<?> carver) {
        this.addCarver(step, (ResourceKey)BuiltinRegistries.f_123860_.m_7854_(carver).orElseThrow());
    }

    public boolean removeCarver(GenerationStep.Carving var1, ResourceKey<ConfiguredWorldCarver<?>> var2);

    default public boolean removeCarver(ResourceKey<ConfiguredWorldCarver<?>> carverKey) {
        boolean anyFound = false;
        for (GenerationStep.Carving step : GenerationStep.Carving.values()) {
            if (!this.removeCarver(step, carverKey)) continue;
            anyFound = true;
        }
        return anyFound;
    }

    default public boolean removeBuiltInCarver(ConfiguredWorldCarver<?> carver) {
        return this.removeCarver((ResourceKey)BuiltinRegistries.f_123860_.m_7854_(carver).orElseThrow());
    }

    default public boolean removeBuiltInCarver(GenerationStep.Carving step, ConfiguredWorldCarver<?> carver) {
        return this.removeCarver(step, (ResourceKey)BuiltinRegistries.f_123860_.m_7854_(carver).orElseThrow());
    }

    public Iterable<Holder<PlacedFeature>> getFeatures(GenerationStep.Decoration var1);

    public Iterable<Holder<ConfiguredWorldCarver<?>>> getCarvers(GenerationStep.Carving var1);
}

